/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import javax.annotation.Nullable;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPartBase
implements IBroomPart {
    private final ResourceLocation id;
    private final IBroomPart.BroomPartType type;
    private final float length;
    private final EnumRarity rarity;
    private final boolean effect;

    public BroomPartBase(ResourceLocation id, IBroomPart.BroomPartType type, float length) {
        this(id, type, length, EnumRarity.COMMON, false);
    }

    public BroomPartBase(ResourceLocation id, IBroomPart.BroomPartType type, float length, EnumRarity rarity, boolean effect) {
        this.id = id;
        this.type = type;
        this.length = length;
        this.rarity = rarity;
        this.effect = effect;
        if (MinecraftHelpers.isClientSide()) {
            this.registerModelResourceLocation();
        }
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModelResourceLocation() {
        BroomParts.REGISTRY.registerPartModel(this, new ResourceLocation(this.getId().func_110624_b(), "broom_part/" + this.getId().func_110623_a().toLowerCase()));
    }

    @Override
    public String getUnlocalizedName() {
        return "broom.parts." + this.getId().func_110624_b() + "." + this.getId().func_110623_a();
    }

    @Override
    @Nullable
    public String getTooltipLine(String prefix) {
        return prefix + L10NHelpers.localize((String)(this.getUnlocalizedName() + ".name"), (Object[])new Object[0]);
    }

    @Override
    public boolean shouldAutoRegisterMissingItem() {
        return true;
    }

    @Override
    public int getModelColor() {
        return Helpers.RGBAToInt((int)255, (int)255, (int)255, (int)255);
    }

    @Override
    public IBroomPart.BroomPartType getType() {
        return this.type;
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public EnumRarity getRarity() {
        return this.rarity;
    }

    @Override
    public boolean isEffect() {
        return this.effect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BroomPartBase)) {
            return false;
        }
        BroomPartBase other = (BroomPartBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLocation this$id = this.getId();
        ResourceLocation other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        IBroomPart.BroomPartType this$type = this.getType();
        IBroomPart.BroomPartType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (Float.compare(this.getLength(), other.getLength()) != 0) {
            return false;
        }
        EnumRarity this$rarity = this.getRarity();
        EnumRarity other$rarity = other.getRarity();
        if (this$rarity == null ? other$rarity != null : !this$rarity.equals(other$rarity)) {
            return false;
        }
        return this.isEffect() == other.isEffect();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BroomPartBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        IBroomPart.BroomPartType $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getLength());
        EnumRarity $rarity = this.getRarity();
        result = result * 59 + ($rarity == null ? 0 : $rarity.hashCode());
        result = result * 59 + (this.isEffect() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BroomPartBase(id=" + this.getId() + ", type=" + this.getType() + ", length=" + this.getLength() + ", rarity=" + this.getRarity() + ", effect=" + this.isEffect() + ")";
    }
}

