/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.client.model.BroomPartModelBaked;

public class BroomPartModel
implements IModel {
    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(BroomParts.REGISTRY.getPartModels());
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        BroomPartModelBaked bakedModel = new BroomPartModelBaked();
        for (IBroomPart part : BroomParts.REGISTRY.getParts()) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)BroomParts.REGISTRY.getPartModel(part));
                IBakedModel bakedAspectModel = model.bake(state, format, bakedTextureGetter);
                bakedModel.addBroomPartModel(part, bakedAspectModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bakedModel;
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }
}

