/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.config.configurable;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.core.tileentity.InnerBlocksTileEntity;

public abstract class ConfigurableBlockWithInnerBlocksExtended
extends ConfigurableBlockContainer {
    public ConfigurableBlockWithInnerBlocksExtended(ExtendedConfig eConfig, Material material, Class<? extends InnerBlocksTileEntity> tileEntity) {
        super(eConfig, material, tileEntity);
        this.setRotatable(false);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
    }

    public boolean saveNBTToDroppedItem() {
        return false;
    }

    public static InnerBlocksTileEntity getTile(IBlockAccess world, BlockPos blockPos) throws InvalidInnerBlocksTileException {
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile == null || !(tile instanceof InnerBlocksTileEntity)) {
            throw new InvalidInnerBlocksTileException();
        }
        return (InnerBlocksTileEntity)tile;
    }

    public boolean removedByPlayer(IBlockState blockState, World world, BlockPos blockPos, EntityPlayer player, boolean willHarvest) {
        this.unwrapInnerBlock(world, blockPos);
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos blockPos, EntityPlayer player) {
        try {
            return ConfigurableBlockWithInnerBlocksExtended.getTile(world, blockPos).getInnerBlockState().func_177230_c().canHarvestBlock(world, blockPos, player);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.canHarvestBlock(world, blockPos, player);
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150348_b.canHarvestBlock(world, blockPos, player);
        }
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos blockPos) {
        try {
            return ConfigurableBlockWithInnerBlocksExtended.getTile((IBlockAccess)world, blockPos).getInnerBlockState().func_177230_c().func_176195_g(blockState, world, blockPos);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_176195_g(blockState, world, blockPos);
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150348_b.func_176195_g(blockState, world, blockPos);
        }
    }

    public float func_180647_a(IBlockState blockState, EntityPlayer player, World world, BlockPos blockPos) {
        try {
            return ConfigurableBlockWithInnerBlocksExtended.getTile((IBlockAccess)world, blockPos).getInnerBlockState().func_177230_c().func_180647_a(blockState, player, world, blockPos);
        }
        catch (InvalidInnerBlocksTileException e) {
            return Blocks.field_150348_b.func_180647_a(blockState, player, world, blockPos);
        }
        catch (IllegalArgumentException e) {
            return Blocks.field_150348_b.func_180647_a(blockState, player, world, blockPos);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos blockPos, EntityPlayer player) {
        IBlockState blockState;
        try {
            blockState = ConfigurableBlockWithInnerBlocksExtended.getTile((IBlockAccess)world, blockPos).getInnerBlockState();
            if (blockState == null) {
                blockState = Blocks.field_150348_b.func_176223_P();
            }
        }
        catch (InvalidInnerBlocksTileException e) {
            blockState = Blocks.field_150348_b.func_176223_P();
        }
        return new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
    }

    public boolean setInnerBlock(World world, BlockPos blockPos) {
        Block block;
        IBlockState blockState = world.func_180495_p(blockPos);
        if (this.canSetInnerBlock(blockState, block = blockState.func_177230_c(), (IBlockAccess)world, blockPos)) {
            IBlockState state = world.func_180495_p(blockPos);
            world.func_180501_a(blockPos, this.func_176223_P(), 2);
            try {
                ConfigurableBlockWithInnerBlocksExtended.getTile((IBlockAccess)world, blockPos).setInnerBlockState(state);
            }
            catch (InvalidInnerBlocksTileException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public IBlockState unwrapInnerBlock(World world, BlockPos blockPos) {
        InnerBlocksTileEntity tile = null;
        try {
            tile = ConfigurableBlockWithInnerBlocksExtended.getTile((IBlockAccess)world, blockPos);
        }
        catch (InvalidInnerBlocksTileException e) {
            e.printStackTrace();
        }
        if (tile == null) {
            return null;
        }
        IBlockState block = tile.getInnerBlockState();
        if (block == null) {
            return null;
        }
        IBlockState state = world.func_180495_p(blockPos);
        world.func_180501_a(blockPos, block, 2);
        return state;
    }

    public boolean canSetInnerBlock(IBlockState blockState, Block block, IBlockAccess world, BlockPos blockPos) {
        return block != null && !block.isAir(blockState, world, blockPos) && block.func_149662_c(blockState) && !block.hasTileEntity(world.func_180495_p(blockPos)) && block.func_149645_b(blockState) == EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState blockStateOuter, World world, RayTraceResult target, ParticleManager particleManager) {
        IBlockState blockState;
        try {
            blockState = ConfigurableBlockWithInnerBlocksExtended.getTile((IBlockAccess)world, target.func_178782_a()).getInnerBlockState();
        }
        catch (InvalidInnerBlocksTileException e) {
            blockState = Blocks.field_150348_b.func_176223_P();
        }
        BlockPos pos = target.func_178782_a();
        RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (World)world, (IBlockState)blockState, (BlockPos)pos, (EnumFacing)target.field_178784_b);
        return true;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColorHandler() {
        return new BlockColor();
    }

    public static class InvalidInnerBlocksTileException
    extends Exception {
    }

    @SideOnly(value=Side.CLIENT)
    public static class BlockColor
    implements IBlockColor {
        @SideOnly(value=Side.CLIENT)
        public int func_186720_a(IBlockState blockState, IBlockAccess world, BlockPos blockPos, int renderPass) {
            try {
                IBlockState innerBlockState = ConfigurableBlockWithInnerBlocksExtended.getTile(world, blockPos).getInnerBlockState();
                return Minecraft.func_71410_x().func_184125_al().func_186724_a(innerBlockState, world, blockPos, renderPass);
            }
            catch (InvalidInnerBlocksTileException e) {
                return -1;
            }
            catch (NullPointerException e) {
                return -1;
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
        }
    }
}

