/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory.container;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.inventory.container.TileInventoryContainer;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;

public class TickingTankInventoryContainer<T extends TickingTankInventoryTileEntity<T>>
extends TileInventoryContainer<T> {
    private Map<TickComponent<T, ITickAction<T>>, Integer> previousTicks = new HashMap<TickComponent<T, ITickAction<T>>, Integer>();
    private static final int INDEX_OFFSET = 1;

    public TickingTankInventoryContainer(InventoryPlayer inventory, T tile) {
        super(inventory, tile);
        for (TickComponent tickComponent : ((TickingTankInventoryTileEntity)((Object)tile)).getTickers()) {
            this.previousTicks.put(tickComponent, tickComponent.getTick());
        }
    }

    public void func_75132_a(IContainerListener icrafting) {
        super.func_75132_a(icrafting);
        this.sendTickersUpdates(icrafting, true);
    }

    private void sendTickersUpdates(IContainerListener icrafting, boolean force) {
        int index = 0;
        for (TickComponent tickComponent : ((TickingTankInventoryTileEntity)this.tile).getTickers()) {
            if (this.previousTicks.get(tickComponent).intValue() != tickComponent.getTick() || force) {
                icrafting.func_71112_a((Container)this, 1 + index, tickComponent.getTick());
                icrafting.func_71112_a((Container)this, 1 + ((TickingTankInventoryTileEntity)this.tile).getTickers().size() + index, Math.round(tickComponent.getRequiredTicks()));
                this.previousTicks.put(tickComponent, tickComponent.getTick());
            }
            ++index;
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener icrafting : this.field_75149_d) {
            this.sendTickersUpdates(icrafting, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int index, int value) {
        if (index >= ((TickingTankInventoryTileEntity)this.tile).getTickers().size() + 1) {
            ((TickingTankInventoryTileEntity)this.tile).getTickers().get(index - ((TickingTankInventoryTileEntity)this.tile).getTickers().size() - 1).setRequiredTicks(value);
        } else if (index >= 1) {
            ((TickingTankInventoryTileEntity)this.tile).getTickers().get(index - 1).setTick(value);
        }
    }
}

