/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class ItemBlockFluidContainer
extends ItemBlockNBT {
    private IBlockTank block;

    public ItemBlockFluidContainer(Block block) {
        super(block);
        this.func_77627_a(false);
        this.block = (IBlockTank)block;
    }

    protected void itemStackDataToTile(ItemStack itemStack, TileEntity tile) {
        BlockTankHelpers.itemStackDataToTile(itemStack, tile);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (this.block.isActivatable()) {
            return new ActionResult(EnumActionResult.PASS, (Object)this.block.toggleActivation(player.func_184586_b(hand), world, player));
        }
        return super.func_77659_a(world, player, hand);
    }

    protected void autofill(int itemSlot, IFluidHandlerItem source, World world, Entity entity) {
        ItemHelpers.updateAutoFill(source, world, entity);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean par5) {
        if (this.block.isActivatable() && this.block.isActivated(itemStack, world, entity)) {
            this.autofill(itemSlot, FluidUtil.getFluidHandler((ItemStack)itemStack), world, entity);
        }
        super.func_77663_a(itemStack, world, entity, itemSlot, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (this.block.isActivatable()) {
            L10NHelpers.addStatusInfo((List)list, (boolean)this.block.isActivated(itemStack, entityPlayer.field_70170_p, (Entity)entityPlayer), (String)(this.func_77658_a() + ".info.auto_supply"));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || oldStack.func_77960_j() != newStack.func_77960_j() || slotChanged;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemCapacity(stack, this.block.getDefaultCapacity());
    }
}

