/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.client.particle.ParticleColoredSmoke;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.entity.item.EntityWeatherContainer;
import org.cyclops.evilcraft.item.Broom;
import org.cyclops.evilcraft.item.BroomConfig;

public class EntityBroom
extends Entity
implements IConfigurable {
    private static final DataParameter<ItemStack> ITEMSTACK_INDEX = EntityDataManager.func_187226_a(EntityWeatherContainer.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final double SPEED = 0.4;
    public static final float MAX_ANGLE = 60.0f;
    public static final float MIN_ANGLE = -60.0f;
    private static final float MAX_COS_AMPLITUDE = 0.2f;
    public EntityLivingBase lastMounted = null;
    private boolean setLast = false;
    private double lastPlayerSpeed = 0.0;
    private float lastRotationPitch = -1.0f;
    private float lastRotationYaw = -1.0f;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    private int newPosRotationIncrements;
    private int broomHoverTickOffset;
    @SideOnly(value=Side.CLIENT)
    private double oldHoverOffset;
    private Map<BroomModifier, Float> cachedModifiers = null;

    public EntityBroom(World world) {
        this(world, 0.0, 0.0, 0.0);
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(World world, double x, double y, double z) {
        super(world);
        this.func_70107_b(x, y, z);
        this.func_70105_a(1.5f, 0.6f);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.initBroomHoverTickOffset();
    }

    protected void initBroomHoverTickOffset() {
        this.broomHoverTickOffset = this.field_70146_Z.nextInt(3);
    }

    public double func_70042_X() {
        return 0.0;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() || player.func_70093_af())) {
            player.func_184220_m((Entity)this);
            this.lastMounted = player;
        }
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        Entity controlling;
        if (!(this.field_70170_p.field_72995_K || entityIn.field_70145_X || this.field_70145_X || entityIn == (controlling = this.func_184179_bs()) || !(entityIn instanceof EntityLivingBase) || entityIn instanceof EntityPlayer || controlling != null || entityIn.func_184218_aH())) {
            entityIn.func_184220_m((Entity)this);
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean isTeleport) {
        posRotationIncrements += 6;
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
        this.newRotationYaw = yaw;
        this.newRotationPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer) {
                if (this.func_184207_aI()) {
                    this.func_184210_p();
                }
                this.func_70106_y();
                EntityPlayer player = (EntityPlayer)source.func_76346_g();
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack itemStack = this.getBroomStack().func_77946_l();
                    this.func_70099_a(itemStack, 0.0f);
                }
            }
        }
        return true;
    }

    public void startAllowFlying(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71075_bZ.field_75101_c = true;
        }
    }

    public void stopAllowFlying(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71075_bZ.field_75101_c = false;
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (!this.field_70170_p.field_72995_K && passenger instanceof EntityLivingBase) {
            this.startAllowFlying((EntityLivingBase)passenger);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Entity rider = this.func_184179_bs();
        if (!this.field_70170_p.field_72995_K && !this.func_184207_aI() && this.lastMounted != null) {
            if (this.lastMounted instanceof EntityPlayer && Configs.isEnabled(BroomConfig.class)) {
                this.stopAllowFlying(this.lastMounted);
                EntityPlayer player = (EntityPlayer)this.lastMounted;
                if (!(player.field_70128_L || MinecraftHelpers.isPlayerInventoryFull((EntityPlayer)player) && !player.field_71075_bZ.field_75098_d)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70441_a(this.getBroomStack());
                    }
                    this.field_70170_p.func_72900_e((Entity)this);
                }
            }
            this.lastMounted = null;
        } else if (rider instanceof EntityLivingBase) {
            List list;
            this.lastMounted = (EntityLivingBase)rider;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            if (!this.field_70170_p.field_72995_K || Minecraft.func_71410_x().field_71439_g == this.lastMounted) {
                this.updateMountedServer();
            } else {
                this.updateMountedClient();
            }
            if (MinecraftHelpers.isClientSide() && this.getModifier(BroomModifiers.PARTICLES) > 0.0f) {
                this.showParticles(this);
            }
            if ((list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) != null && !list.isEmpty()) {
                for (int l = 0; l < list.size(); ++l) {
                    Entity entity = (Entity)list.get(l);
                    if (entity == rider || !entity.func_70104_M() || entity instanceof EntityBroom) continue;
                    for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                        for (BroomModifier.ICollisionListener listener : entry.getKey().getCollisionListeners()) {
                            listener.onCollide(this, entity, entry.getValue().floatValue());
                        }
                    }
                    entity.func_70108_f((Entity)this);
                    float toughnessModifier = Math.min(1.0f, 0.5f + this.getModifier(BroomModifiers.STURDYNESS) / (BroomModifiers.STURDYNESS.getMaxTierValue() * 1.5f) / 2.0f);
                    this.setLastPlayerSpeed(this.getLastPlayerSpeed() * (double)toughnessModifier);
                }
            }
            for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                for (BroomModifier.ITickListener listener : entry.getKey().getTickListeners()) {
                    listener.onTick(this, entry.getValue().floatValue());
                }
            }
        } else {
            if (!this.field_70170_p.field_72995_K && rider == null) {
                this.collideWithNearbyEntities();
            }
            this.updateUnmounted();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void showParticles(EntityBroom broom) {
        World world = broom.field_70170_p;
        if (world.field_72995_K && broom.lastMounted.field_70701_bs != 0.0f) {
            int particles = (int)(broom.getModifier(BroomModifiers.PARTICLES) * (float)broom.getLastPlayerSpeed());
            Triple<Float, Float, Float> color = BroomModifier.getAverageColor(broom.getModifiers());
            for (int i = 0; i < particles; ++i) {
                float r = ((Float)color.getLeft()).floatValue();
                float g = ((Float)color.getMiddle()).floatValue();
                float b = ((Float)color.getRight()).floatValue();
                ParticleColoredSmoke smoke = new ParticleColoredSmoke(world, broom.field_70165_t - broom.field_70159_w * 1.5 + Math.random() * 0.4 - 0.2, broom.field_70163_u - broom.field_70181_x * 1.5 + Math.random() * 0.4 - 0.2, broom.field_70161_v - broom.field_70179_y * 1.5 + Math.random() * 0.4 - 0.2, r, g, b, broom.field_70159_w / 10.0, broom.field_70181_x / 10.0, broom.field_70179_y / 10.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smoke);
            }
        }
    }

    protected void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                return p_apply_1_.func_70104_M();
            }
        }));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                this.func_70108_f(entity);
            }
        }
    }

    protected void updateMountedClient() {
        if (this.newPosRotationIncrements > 0) {
            double x = this.field_70165_t + (this.newPosX - this.field_70165_t) / (double)this.newPosRotationIncrements;
            double y = this.field_70163_u + (this.newPosY - this.field_70163_u) / (double)this.newPosRotationIncrements;
            double z = this.field_70161_v + (this.newPosZ - this.field_70161_v) / (double)this.newPosRotationIncrements;
            float yaw = MathHelpers.normalizeAngle_180((float)(this.newRotationYaw - (double)this.field_70177_z));
            this.field_70177_z += yaw / (float)this.newPosRotationIncrements;
            this.field_70125_A = (float)((double)this.field_70125_A + (this.newRotationPitch - (double)this.field_70125_A) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.func_70107_b(x, y, z);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.func_70091_d(MoverType.SELF, 0.0, this.getHoverOffset(), 0.0);
    }

    public boolean canConsume(int amount, EntityLivingBase entityLiving) {
        ItemStack broomStack = this.getBroomStack();
        return broomStack != null && broomStack.func_77973_b() instanceof IBroom && ((IBroom)broomStack.func_77973_b()).canConsumeBroomEnergy(amount, broomStack, entityLiving);
    }

    public void consume(int amount, EntityLivingBase entityLiving) {
        float efficiencyFactor = Math.min(0.9f, Math.max(0.0f, this.getModifier(BroomModifiers.EFFICIENCY) / BroomModifiers.EFFICIENCY.getMaxTierValue()));
        if (this.field_70170_p.field_73012_v.nextFloat() > efficiencyFactor) {
            ItemStack broomStack = this.getBroomStack();
            ((IBroom)broomStack.func_77973_b()).consumeBroom(amount, broomStack, entityLiving);
            this.setBroomStack(broomStack);
        }
    }

    protected void updateMountedServer() {
        if (!this.setLast) {
            this.setLast = true;
            this.lastRotationYaw = this.field_70177_z;
            this.lastRotationPitch = this.field_70125_A;
        }
        if (!(this.lastMounted instanceof EntityPlayer)) {
            this.lastMounted.field_70177_z = this.lastMounted.field_70759_as;
            this.lastMounted.field_70701_bs = 0.5f;
        }
        this.field_70125_A = MathHelpers.normalizeAngle_180(this.lastMounted.field_70125_A);
        this.field_70177_z = MathHelpers.normalizeAngle_180(this.lastMounted.field_70177_z);
        float maneuverabilityFactor = 1.0f - this.getModifier(BroomModifiers.MANEUVERABILITY) / 2000.0f;
        this.field_70125_A = this.field_70125_A * (1.0f - maneuverabilityFactor) + this.lastRotationPitch * maneuverabilityFactor;
        if (this.lastRotationYaw - this.field_70177_z > 180.0f) {
            this.lastRotationYaw -= 360.0f;
        }
        if (this.lastRotationYaw - this.field_70177_z < -180.0f) {
            this.lastRotationYaw += 360.0f;
        }
        this.field_70177_z = this.field_70177_z * (1.0f - maneuverabilityFactor) + this.lastRotationYaw * maneuverabilityFactor;
        this.lastRotationPitch = this.field_70125_A;
        this.lastRotationYaw = this.field_70177_z;
        if (this.field_70125_A > 60.0f) {
            this.field_70125_A = 60.0f;
        } else if (this.field_70125_A < -60.0f) {
            this.field_70125_A = -60.0f;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        double pitch = (double)(this.field_70125_A + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(this.field_70177_z + 90.0f) * Math.PI / 180.0;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double z = Math.sin(pitch) * Math.sin(yaw);
        double y = Math.cos(pitch);
        double playerSpeed = this.lastMounted.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        playerSpeed += (double)(this.getModifier(BroomModifiers.SPEED) / 100.0f);
        int amount = BroomConfig.bloodUsage;
        EntityLivingBase currentRidingEntity = this.func_184179_bs() instanceof EntityLivingBase ? (EntityLivingBase)this.func_184179_bs() : null;
        float moveForward = this.canConsume(amount, currentRidingEntity) ? this.lastMounted.field_70701_bs : this.lastMounted.field_70701_bs / 10.0f;
        playerSpeed *= (double)moveForward;
        if (moveForward != 0.0f) {
            this.consume(amount, currentRidingEntity);
        }
        float slowingFactor = 1.0f - (this.getModifier(BroomModifiers.ACCELERATION) + 1.0f) / 2500.0f;
        playerSpeed = playerSpeed * (1.0 - (double)slowingFactor) + this.lastPlayerSpeed * (double)slowingFactor;
        float levitation = this.getModifier(BroomModifiers.LEVITATION);
        float levitationModifier = levitation / BroomModifiers.LEVITATION.getMaxTierValue() * 1.5f;
        levitationModifier = Math.max(0.2f, levitationModifier);
        if (y < 0.0) {
            levitationModifier = Math.max(1.0f, levitationModifier);
        }
        this.field_70159_w = this.field_70159_w / 10.0 + x * 0.4 * playerSpeed;
        this.field_70181_x = this.field_70181_x / 10.0 + y * 0.4 * playerSpeed * (double)levitationModifier;
        this.field_70179_y = this.field_70179_y / 10.0 + z * 0.4 * playerSpeed;
        if (this.field_70171_ac) {
            float waterMovementFactor = 1.0f - MathHelper.func_76131_a((float)(this.getModifier(BroomModifiers.SWIMMING) / (BroomModifiers.SWIMMING.getMaxTierValue() * 1.1f)), (float)0.0f, (float)1.0f);
            this.field_70159_w /= (double)(1.0f + 4.0f * waterMovementFactor);
            this.field_70181_x /= (double)(1.0f + 4.0f * waterMovementFactor);
            this.field_70179_y /= (double)(1.0f + 4.0f * waterMovementFactor);
            this.field_70181_x += (double)(0.05f * waterMovementFactor);
        }
        this.lastPlayerSpeed = playerSpeed;
        if (this.field_70170_p.field_72995_K) {
            this.field_70181_x += this.getHoverOffset();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public double getLastPlayerSpeed() {
        return this.lastPlayerSpeed;
    }

    public void setLastPlayerSpeed(double lastPlayerSpeed) {
        this.lastPlayerSpeed = lastPlayerSpeed;
    }

    protected void updateUnmounted() {
        if (this.field_70170_p.field_72995_K) {
            this.func_70091_d(MoverType.SELF, 0.0, this.getHoverOffset(), 0.0);
        }
    }

    protected double getHoverOffset() {
        float x = this.field_70170_p.func_72820_D();
        float t = this.broomHoverTickOffset;
        double newHoverOffset = Math.cos(x / 10.0f + t) * Math.cos(x / 12.0f + t) * Math.cos(x / 15.0f + t) * (double)0.2f;
        double newHoverDifference = newHoverOffset - this.oldHoverOffset;
        this.oldHoverOffset += newHoverDifference;
        return newHoverDifference;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEMSTACK_INDEX, (Object)new ItemStack((Item)Broom.getInstance()));
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public ExtendedConfig<?> getConfig() {
        return null;
    }

    public void setBroomStack(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(ITEMSTACK_INDEX, (Object)itemStack.func_77946_l());
    }

    public ItemStack getBroomStack() {
        ItemStack itemStack = (ItemStack)this.field_70180_af.func_187225_a(ITEMSTACK_INDEX);
        if (itemStack.func_190926_b()) {
            itemStack = new ItemStack((Item)Broom.getInstance());
        }
        itemStack.func_190920_e(1);
        return itemStack;
    }

    public Map<BroomModifier, Float> getModifiers() {
        if (this.cachedModifiers == null) {
            this.cachedModifiers = Maps.newHashMap();
            ItemStack broomStack = this.getBroomStack();
            Map<BroomModifier, Float> modifiers = BroomModifiers.REGISTRY.getModifiers(broomStack);
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(broomStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(modifiers.keySet());
            modifierTypes.addAll(baseModifiers.keySet());
            for (BroomModifier modifier : modifierTypes) {
                float value = modifier.getDefaultValue();
                if (baseModifiers.containsKey(modifier)) {
                    value = baseModifiers.get(modifier).floatValue();
                }
                if (modifiers.containsKey(modifier)) {
                    value = modifier.apply(value, Lists.newArrayList((Object[])new Float[]{modifiers.get(modifier)}));
                }
                this.cachedModifiers.put(modifier, Float.valueOf(value));
            }
        }
        return this.cachedModifiers;
    }

    public float getModifier(BroomModifier modifier) {
        Float value = this.getModifiers().get(modifier);
        if (value == null) {
            return modifier.getDefaultValue();
        }
        return value.floatValue();
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tag) {
        tag = super.func_189511_e(tag);
        NBTTagCompound broomItemTag = new NBTTagCompound();
        this.getBroomStack().func_77955_b(broomItemTag);
        tag.func_74782_a("broomItem", (NBTBase)broomItemTag);
        return tag;
    }

    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        ItemStack broomStack = new ItemStack(tagCompound.func_74775_l("broomItem"));
        if (broomStack != null) {
            this.setBroomStack(broomStack);
        }
    }
}

