/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.entity.item.EntityBiomeExtract;
import org.cyclops.evilcraft.item.BiomeExtractConfig;

public class BiomeExtract
extends ConfigurableItem {
    private static final String NBT_BIOMEKEY = "biomeKey";
    private static BiomeExtract _instance = null;

    public static BiomeExtract getInstance() {
        return _instance;
    }

    public BiomeExtract(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + (itemStack.func_77952_i() == 0 ? ".empty" : "");
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K && this.getBiome(itemStack) != null && !BiomeExtractConfig._instance.isUsageBlacklisted(this.getBiome(itemStack))) {
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, new SoundEvent(new ResourceLocation("random.bow")), SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            EntityBiomeExtract entity = new EntityBiomeExtract(world, (EntityLivingBase)player, itemStack.func_77946_l());
            entity.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
            world.func_72838_d((Entity)entity);
            itemStack.func_190918_g(1);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        Biome biome = this.getBiome(itemStack);
        if (biome != null) {
            list.add(L10NHelpers.localize((String)(this.func_77658_a() + ".info.content"), (Object[])new Object[]{biome.func_185359_l()}));
        }
    }

    public Iterable<Biome> getBiomes() {
        return Biome.field_185377_q;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        super.func_150895_a(item, creativeTabs, list);
        if (BiomeExtractConfig.creativeTabVariants) {
            for (Biome biome : this.getBiomes()) {
                list.add((Object)this.createItemStack(biome, 1));
            }
        }
    }

    public boolean isEmpty(ItemStack itemStack) {
        return this.getBiome(itemStack) == null;
    }

    public Biome getBiome(ItemStack itemStack) {
        String biomeName;
        if (itemStack.func_77942_o() && Biome.field_185377_q.func_148741_d((Object)new ResourceLocation(biomeName = itemStack.func_77978_p().func_74779_i(NBT_BIOMEKEY)))) {
            return (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeName));
        }
        return null;
    }

    public ItemStack createItemStack(Biome biome, int amount) {
        ItemStack itemStack = new ItemStack((Item)BiomeExtract.getInstance(), amount, biome == null ? 0 : 1);
        if (biome != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a(NBT_BIOMEKEY, ((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome)).toString());
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        Biome biome = this.getBiome(itemStack);
        if (biome == null) {
            return EnumRarity.COMMON;
        }
        return biome.func_76741_f() <= 0.05f ? EnumRarity.EPIC : (biome.func_76741_f() <= 0.1f ? EnumRarity.RARE : EnumRarity.UNCOMMON);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColorHandler() {
        return new ItemColor();
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int func_186726_a(ItemStack itemStack, int renderPass) {
            if (renderPass == 0 && itemStack.func_77952_i() > 0) {
                Biome biome = BiomeExtract.getInstance().getBiome(itemStack);
                if (biome != null) {
                    return biome.func_180625_c(new BlockPos(0, 0, 0));
                }
                return Helpers.RGBToInt((int)125, (int)125, (int)125);
            }
            return 0xFFFFFF;
        }
    }
}

