/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPart
extends ConfigurableItem {
    private static BroomPart _instance = null;

    public static BroomPart getInstance() {
        return _instance;
    }

    public BroomPart(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77627_a(true);
    }

    public IBroomPart getPart(ItemStack itemStack) {
        return BroomParts.REGISTRY.getPartFromItem(itemStack);
    }

    public String func_77667_c(ItemStack itemStack) {
        IBroomPart part = this.getPart(itemStack);
        if (part != null) {
            return part.getUnlocalizedName();
        }
        return super.func_77667_c(itemStack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        IBroomPart part = this.getPart(stack);
        if (part != null) {
            return part.getRarity();
        }
        return super.func_77613_e(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        IBroomPart part = this.getPart(stack);
        if (part != null) {
            return part.isEffect();
        }
        return super.func_77636_d(stack);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (IBroomPart part : BroomParts.REGISTRY.getParts()) {
            for (ItemStack itemStack : BroomParts.REGISTRY.getItemsFromPart(part)) {
                if (itemStack.func_77973_b() != this) continue;
                subItems.add((Object)itemStack);
            }
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColorHandler() {
        return new ItemColor();
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int func_186726_a(ItemStack itemStack, int renderPass) {
            IBroomPart part = BroomPart.getInstance().getPart(itemStack);
            if (part != null) {
                return part.getModelColor();
            }
            return -1;
        }
    }
}

