/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.LootHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.fluid.Blood;

public class CondensedBloodConfig
extends ItemConfig {
    public static CondensedBloodConfig _instance;

    public CondensedBloodConfig() {
        super((ModBase)EvilCraft._instance, true, "condensed_blood", null, null);
    }

    protected IConfigurable initSubInstance() {
        return new ConfigurableItem((ExtendedConfig)this){

            public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                return new FluidWrapper(stack);
            }
        };
    }

    public void onRegistered() {
        LootHelpers.addVanillaLootChestLootEntry((LootEntryItem[])new LootEntryItem[]{new LootEntryItem(this.getItemInstance(), 5, 1, new LootFunction[]{new LootFunction(new LootCondition[0]){

            public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
                stack.func_190917_f(rand.nextInt(32));
                return stack;
            }
        }}, new LootCondition[0], this.getMod().getModId() + ":" + this.getSubUniqueName())});
    }

    public static class FluidWrapper
    extends FluidBucketWrapper {
        public FluidWrapper(ItemStack container) {
            super(container);
        }

        protected int getVolume() {
            return 500;
        }

        @Nullable
        public FluidStack getFluid() {
            return new FluidStack((Fluid)Blood.getInstance(), this.getVolume());
        }

        protected void setFluid(Fluid fluid) {
            if (fluid == null) {
                this.container = this.container.func_77946_l();
                this.container.func_190918_g(1);
            }
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount < this.getVolume()) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
                if (doDrain) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain < this.getVolume()) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null) {
                if (doDrain) {
                    this.setFluid(null);
                }
                return fluidStack;
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.getVolume())};
        }
    }
}

