/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.BloodStainedBlock;
import org.cyclops.evilcraft.block.BloodStainedBlockConfig;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.fluid.Blood;

public class CreativeBloodDrop
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static CreativeBloodDrop _instance = null;
    private static final int MB_FILL_PERTICK = 1000;

    public static CreativeBloodDrop getInstance() {
        return _instance;
    }

    public CreativeBloodDrop(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 1000, (Fluid)Blood.getInstance());
        this.setPlaceFluids(true);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo((List)list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.autoSupply"));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        CreativeBloodDrop.updateAutoFill(itemStack, world, entity);
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public static void updateAutoFill(ItemStack itemStack, World world, Entity entity) {
        FluidStack tickFluid;
        IFluidHandlerItem source = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (source != null && entity instanceof EntityPlayer && !world.field_72995_K && ItemHelpers.isActivated(itemStack) && (tickFluid = source.drain(Integer.MAX_VALUE, false)) != null && tickFluid.amount > 0) {
            EntityPlayer player = (EntityPlayer)entity;
            for (EnumHand hand : EnumHand.values()) {
                ItemStack held = player.func_184586_b(hand);
                IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)held);
                if (held.func_190926_b() || held == itemStack || fluidHandler == null || player.func_184605_cv() != 0 || fluidHandler.fill(tickFluid, false) <= 0) continue;
                int filled = fluidHandler.fill(new FluidStack(tickFluid.getFluid(), 1000), true);
                source.drain(filled, true);
            }
        }
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        itemList.add((Object)new ItemStack((Item)this));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (player.func_70093_af() && Configs.isEnabled(BloodStainedBlockConfig.class) && (BloodStainedBlock.getInstance().canSetInnerBlock(world.func_180495_p(blockPos), block, (IBlockAccess)world, blockPos) || block == BloodStainedBlock.getInstance())) {
            BloodStainedBlock.getInstance().stainBlock(world, blockPos, 1000);
            if (world.field_72995_K) {
                ParticleBloodSplash.spawnParticles(world, blockPos.func_177982_a(0, 1, 0), 5, 1 + world.field_73012_v.nextInt(2));
            }
            return EnumActionResult.PASS;
        }
        return super.onItemUseFirst(player, world, blockPos, side, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult target = this.func_77621_a(world, player, false);
        if (!(target != null && target.field_72313_a != RayTraceResult.Type.MISS || world.field_72995_K)) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemCapacity(stack, 1000){

            public FluidStack getFluid() {
                return new FluidStack(CreativeBloodDrop.this.getFluid(), 500);
            }

            public FluidStack drain(int maxDrain, boolean doDrain) {
                return new FluidStack(this.getFluid(), maxDrain);
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (resource == null) {
                    return 0;
                }
                return resource.amount;
            }
        };
    }
}

