/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.evilcraft.client.gui.container.GuiExaltedCrafter;
import org.cyclops.evilcraft.entity.item.EntityItemEmpowerable;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class ExaltedCrafter
extends ItemGui
implements IItemEmpowerable {
    private static final String NBT_RETURNTOINNER = "returnToInner";
    private static ExaltedCrafter _instance = null;

    public static ExaltedCrafter getInstance() {
        return _instance;
    }

    public ExaltedCrafter(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isEmpowered(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return this.isEmpowered(itemStack) ? EnumRarity.UNCOMMON : super.func_77613_e(itemStack);
    }

    @Override
    public boolean isEmpowered(ItemStack itemStack) {
        return (itemStack.func_77952_i() >> 1 & 1) == 1;
    }

    @Override
    public ItemStack empower(ItemStack itemStack) {
        if (itemStack.func_77973_b() == this) {
            itemStack.func_77964_b(itemStack.func_77952_i() | 2);
        }
        return itemStack;
    }

    public boolean isWooden(ItemStack itemStack) {
        return (itemStack.func_77952_i() & 1) == 1;
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77658_a() + (this.isWooden(itemStack) ? ".wood" : "");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        itemList.add((Object)new ItemStack(item, 1, 0));
        itemList.add((Object)new ItemStack(item, 1, 1));
        itemList.add((Object)new ItemStack(item, 1, 2));
        itemList.add((Object)new ItemStack(item, 1, 3));
    }

    public IInventory getSupplementaryInventory(EntityPlayer player, ItemStack itemStack, int itemIndex) {
        if (this.isWooden(itemStack)) {
            return new NBTSimpleInventoryItemHeld(player, itemIndex, 27, 64);
        }
        return player.func_71005_bN();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (this.isEmpowered(itemStack)) {
            list.add(TextFormatting.RED + "Empowered");
        }
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemStack) {
        return new EntityItemEmpowerable(world, (EntityItem)location);
    }

    public void setReturnToInner(ItemStack itemStack, boolean returnToInner) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_74757_a(NBT_RETURNTOINNER, returnToInner);
        }
    }

    public boolean isReturnToInner(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74767_n(NBT_RETURNTOINNER);
        }
        return false;
    }

    public Class<? extends Container> getContainer() {
        return ContainerExaltedCrafter.class;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiExaltedCrafter.class;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        ItemHandler itemHandler = new ItemHandler(stack);
        return new ICapabilityProvider((IItemHandler)itemHandler){
            final /* synthetic */ IItemHandler val$itemHandler;
            {
                this.val$itemHandler = iItemHandler;
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return ExaltedCrafter.this.isWooden(stack) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(ExaltedCrafter.this.isWooden(stack) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.val$itemHandler : null);
            }
        };
    }

    public class ItemHandler
    implements IItemHandlerModifiable {
        protected ItemStack itemStack;

        public ItemHandler(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        protected NonNullList<ItemStack> getItemList() {
            NonNullList itemStacks = NonNullList.func_191197_a((int)this.getSlots(), (Object)ItemStack.field_190927_a);
            NBTTagCompound rootTag = this.itemStack.func_77978_p();
            if (rootTag != null && rootTag.func_150297_b("NBTSimpleInventory", MinecraftHelpers.NBTTag_Types.NBTTagList.ordinal())) {
                NBTTagList nbttaglist = rootTag.func_150295_c("NBTSimpleInventory", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
                for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                    NBTTagCompound slot = nbttaglist.func_150305_b(j);
                    int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
                    if (index < 0 || index >= this.getSlots()) continue;
                    itemStacks.set(index, (Object)new ItemStack(slot));
                }
            }
            return itemStacks;
        }

        protected void setItemList(NonNullList<ItemStack> itemStacks) {
            NBTTagCompound rootTag = ItemStackHelpers.getSafeTagCompound((ItemStack)this.itemStack);
            NBTTagList slots = new NBTTagList();
            for (byte index = 0; index < this.getSlots(); index = (byte)((byte)(index + 1))) {
                ItemStack itemStack = (ItemStack)itemStacks.get((int)index);
                if (itemStack.func_190926_b() || itemStack.func_190916_E() <= 0) continue;
                NBTTagCompound slot = new NBTTagCompound();
                slots.func_74742_a((NBTBase)slot);
                slot.func_74774_a("Slot", index);
                itemStack.func_77955_b(slot);
            }
            rootTag.func_74782_a("NBTSimpleInventory", (NBTBase)slots);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            NonNullList<ItemStack> itemStacks = this.getItemList();
            itemStacks.set(slot, (Object)stack);
            this.setItemList(itemStacks);
        }

        public int getSlots() {
            return 27;
        }

        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.getItemList().get(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            NonNullList<ItemStack> itemStacks = this.getItemList();
            ItemStack existingStack = (ItemStack)itemStacks.get(slot);
            if (!existingStack.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack)) {
                    return stack;
                }
                int maxStackSize = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - existingStack.func_190916_E();
                if (stack.func_190916_E() <= maxStackSize) {
                    if (!simulate) {
                        ItemStack copy = stack.func_77946_l();
                        copy.func_190917_f(existingStack.func_190916_E());
                        this.setStackInSlot(slot, copy);
                    }
                    return ItemStack.field_190927_a;
                }
                stack = stack.func_77946_l();
                if (!simulate) {
                    ItemStack copy = stack.func_77979_a(maxStackSize);
                    copy.func_190917_f(existingStack.func_190916_E());
                    this.setStackInSlot(slot, copy);
                    return stack;
                }
                stack.func_190918_g(maxStackSize);
                return stack;
            }
            int maxStackSize = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
            if (maxStackSize < stack.func_190916_E()) {
                stack = stack.func_77946_l();
                if (!simulate) {
                    this.setStackInSlot(slot, stack.func_77979_a(maxStackSize));
                    return stack;
                }
                stack.func_190918_g(maxStackSize);
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack);
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack existingStack = this.getStackInSlot(slot);
            if (existingStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack extracted = existingStack.func_77979_a(amount);
            if (!simulate) {
                this.setStackInSlot(slot, existingStack);
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

