/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProviderConfigurable;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemStack;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.client.gui.container.GuiPrimedPendant;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.inventory.container.ContainerPrimedPendant;
import org.cyclops.evilcraft.item.PrimedPendantConfig;
import org.cyclops.evilcraft.modcompat.baubles.BaublesModCompat;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public class PrimedPendant
extends ConfigurableDamageIndicatedItemFluidContainer
implements IBauble,
IGuiContainerProviderConfigurable {
    private static final int TICK_MODULUS = 10;
    private static PrimedPendant _instance = null;
    private int guiID;

    public static PrimedPendant getInstance() {
        return _instance;
    }

    public PrimedPendant(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, PrimedPendantConfig.capacity, (Fluid)Blood.getInstance());
        this.func_77625_d(1);
        this.guiID = Helpers.getNewId((ModBase)EvilCraft._instance, (Helpers.IDType)Helpers.IDType.GUI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        ItemStack potionStack = this.getPotionStack(itemStack);
        if (!potionStack.func_190926_b()) {
            List potionEffects = PotionUtils.func_185189_a((ItemStack)potionStack);
            for (PotionEffect potionEffect : potionEffects) {
                Double multiplier = PrimedPendantConfig._instance.getMultiplier(potionEffect.func_188419_a());
                String striked = multiplier != null && multiplier < 0.0 ? "\u00a7m" : "";
                list.add(L10NHelpers.localize((String)(super.func_77667_c(itemStack) + ".potion"), (Object[])new Object[]{striked + L10NHelpers.localize((String)potionEffect.func_76453_d(), (Object[])new Object[0]), I18n.func_74838_a((String)("enchantment.level." + (potionEffect.func_76458_c() + 1)))}));
            }
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer && world.func_72820_D() % 10L == 0L) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack potionStack = this.getPotionStack(itemStack);
            if (!potionStack.func_190926_b()) {
                List potionEffects = PotionUtils.func_185189_a((ItemStack)potionStack);
                for (PotionEffect potionEffect : potionEffects) {
                    int toDrain = PrimedPendantConfig.usage * (potionEffect.func_76458_c() + 1);
                    Double multiplier = PrimedPendantConfig._instance.getMultiplier(potionEffect.func_188419_a());
                    if (multiplier != null) {
                        toDrain = (int)((double)toDrain * multiplier);
                    }
                    if (multiplier != null && !(multiplier >= 0.0) || !this.canConsume(toDrain, itemStack, player)) continue;
                    player.func_70690_d(new PotionEffect(potionEffect.func_188419_a(), 270, potionEffect.func_76458_c(), !potionEffect.getCurativeItems().isEmpty(), true));
                    this.consume(toDrain, itemStack, player);
                }
            }
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public boolean hasPotionStack(ItemStack itemStack) {
        return !this.getPotionStack(itemStack).func_190926_b();
    }

    public ItemStack getPotionStack(ItemStack itemStack) {
        IInventory inventory = this.getSupplementaryInventory(itemStack);
        return inventory.func_70301_a(0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return this.hasPotionStack(itemStack);
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemStack, EntityLivingBase entity) {
        return BaublesModCompat.canUse();
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entity) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack itemStack, EntityLivingBase entity) {
        if (BaublesModCompat.canUse()) {
            this.func_77663_a(itemStack, entity.field_70170_p, (Entity)entity, 0, false);
        }
    }

    public IInventory getSupplementaryInventory(EntityPlayer player, ItemStack itemStack, int itemIndex) {
        return new NBTSimpleInventoryItemHeld(player, itemIndex, 1, 64);
    }

    public IInventory getSupplementaryInventory(ItemStack itemStack) {
        return new NBTSimpleInventoryItemStack(itemStack, 1, 64);
    }

    public int getGuiID() {
        return this.guiID;
    }

    public Class<? extends Container> getContainer() {
        return ContainerPrimedPendant.class;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiPrimedPendant.class;
    }

    public ModBase getModGui() {
        return EvilCraft._instance;
    }

    public boolean onDroppedByPlayer(ItemStack itemStack, EntityPlayer player) {
        if (!itemStack.func_190926_b() && player instanceof EntityPlayerMP && player.field_71070_bA != null && player.field_71070_bA.getClass() == this.getContainer()) {
            ((EntityPlayerMP)player).func_71053_j();
        }
        return super.onDroppedByPlayer(itemStack, player);
    }

    public void openGuiForItemIndex(World world, EntityPlayer player, int itemIndex) {
        EvilCraft._instance.getGuiHandler().setTemporaryData(GuiHandler.GuiType.ITEM, (Object)itemIndex);
        if (!world.field_72995_K || this.isClientSideOnlyGui()) {
            player.openGui((Object)EvilCraft._instance, this.getGuiID(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    protected boolean isClientSideOnlyGui() {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        this.openGuiForItemIndex(world, player, player.field_71071_by.field_70461_c);
        return MinecraftHelpers.successAction((Object)itemStack);
    }
}

