/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.entity.item.EntityWeatherContainer;

public class WeatherContainer
extends ConfigurableItem {
    private static WeatherContainer _instance = null;

    public static WeatherContainer getInstance() {
        return _instance;
    }

    public WeatherContainer(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromDamage(int damage) {
        return WeatherContainer.getWeatherContainerType(damage).damageRenderColor;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K && WeatherContainer.getWeatherContainerType(itemStack) != WeatherContainerTypes.EMPTY) {
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            EntityWeatherContainer entity = new EntityWeatherContainer(world, (EntityLivingBase)player, itemStack.func_77946_l());
            entity.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
            world.func_72838_d((Entity)entity);
            itemStack.func_190918_g(1);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public void onUse(World world, ItemStack itemStack) {
        WeatherContainer.getWeatherContainerType(itemStack).onUse(world, itemStack);
    }

    public void onFill(World world, ItemStack itemStack) {
        WeatherContainer.getWeatherContainerType(itemStack).onFill(world, itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        WeatherContainerTypes type = WeatherContainer.getWeatherContainerType(itemStack);
        list.add(type.damageColor + type.description);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < WeatherContainerTypes.values().length; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public static boolean isEmpty(int itemDamage) {
        return itemDamage == WeatherContainerTypes.EMPTY.ordinal();
    }

    public static WeatherContainerTypes getWeatherContainerType(int damage) {
        if (damage > WeatherContainerTypes.values().length) {
            return WeatherContainerTypes.EMPTY;
        }
        return WeatherContainerTypes.values()[damage];
    }

    public static WeatherContainerTypes getWeatherContainerType(ItemStack stack) {
        return WeatherContainer.getWeatherContainerType(stack.func_77952_i());
    }

    public static ItemStack createItemStack(WeatherContainerTypes type, int amount) {
        return new ItemStack((Item)WeatherContainer.getInstance(), amount, type.ordinal());
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return itemStack.func_77952_i() == 0 ? EnumRarity.COMMON : (itemStack.func_77952_i() > 2 ? EnumRarity.RARE : EnumRarity.UNCOMMON);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColorHandler() {
        return new ItemColor();
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int func_186726_a(ItemStack itemStack, int renderPass) {
            return renderPass > 0 ? 0xFFFFFF : WeatherContainer.getInstance().getColorFromDamage(itemStack.func_77952_i());
        }
    }

    public static enum WeatherContainerTypes {
        EMPTY(null, "empty", TextFormatting.GRAY, Helpers.RGBToInt((int)125, (int)125, (int)125)),
        CLEAR(WeatherType.CLEAR, "clear", TextFormatting.AQUA, Helpers.RGBToInt((int)30, (int)150, (int)230)),
        RAIN(WeatherType.RAIN, "rain", TextFormatting.DARK_BLUE, Helpers.RGBToInt((int)0, (int)0, (int)255)),
        LIGHTNING(WeatherType.LIGHTNING, "lightning", TextFormatting.GOLD, Helpers.RGBToInt((int)255, (int)215, (int)0));

        private final WeatherType type;
        private final String description;
        private final TextFormatting damageColor;
        private final int damageRenderColor;

        private WeatherContainerTypes(WeatherType type, String description, TextFormatting damageColor, int damageRenderColor) {
            this.type = type;
            this.description = L10NHelpers.localize((String)("weather_container.evilcraft." + description), (Object[])new Object[0]);
            this.damageColor = damageColor;
            this.damageRenderColor = damageRenderColor;
        }

        public void onFill(World world, ItemStack containerStack) {
            WeatherContainerTypes currentWeatherType = EMPTY;
            for (WeatherContainerTypes type : WeatherContainerTypes.values()) {
                if (type.type == null || !type.type.isActive(world)) continue;
                currentWeatherType = type;
            }
            containerStack.func_77964_b(currentWeatherType.ordinal());
            currentWeatherType.type.deactivate(world);
        }

        public void onUse(World world, ItemStack containerStack) {
            if (world.field_72995_K) {
                return;
            }
            if (this.type != null) {
                this.type.activate(world);
            }
            containerStack.func_77964_b(EMPTY.ordinal());
        }

        public static WeatherContainerTypes getWeatherContainerType(WeatherType weatherType) {
            for (WeatherContainerTypes type : WeatherContainerTypes.values()) {
                if (type.type != weatherType) continue;
                return type;
            }
            return null;
        }
    }
}

