/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItemFood;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.Achievements;

public class WerewolfFlesh
extends ConfigurableItemFood {
    private static WerewolfFlesh _instance = null;
    private static final int POISON_DURATION = 10;
    private static final int POWER_DURATION = 60;
    private static final int POWER_DURATION_BONUS = 240;
    private boolean power = false;

    public String func_77667_c(ItemStack itemStack) {
        if (this.isHumanFlesh(itemStack)) {
            return "item.items.evilcraft.human_flesh";
        }
        return "item.items.evilcraft." + this.eConfig.getNamedId();
    }

    public static WerewolfFlesh getInstance() {
        return _instance;
    }

    public WerewolfFlesh(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, -5, 0.0f, false);
        this.func_77627_a(true);
        this.func_77848_i();
        this.func_77625_d(16);
    }

    private boolean isPower() {
        return this.power;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return this.isHumanFlesh(itemStack) ? EnumRarity.RARE : EnumRarity.EPIC;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isPower();
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity player, int par4, boolean par5) {
        this.power = !MinecraftHelpers.isDay((World)world);
    }

    private int getPowerDuration(ItemStack itemStack) {
        if (this.isHumanFlesh(itemStack)) {
            return 60;
        }
        return 240;
    }

    private boolean isHumanFlesh(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1;
    }

    private boolean isOwnCanibal(ItemStack itemStack, EntityPlayer player) {
        if (itemStack.func_77978_p() != null) {
            GameProfile profile = NBTUtil.func_152459_a((NBTTagCompound)itemStack.func_77978_p());
            return player.func_146103_bH().equals((Object)profile);
        }
        return false;
    }

    public ItemStack func_77654_b(ItemStack itemStack, @Nullable World world, EntityLivingBase entity) {
        if (world != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            itemStack.func_190918_g(1);
            if (itemStack.func_77952_i() == 1) {
                player.func_71064_a((StatBase)Achievements.CANNIBAL, 1);
            }
            if (this.isOwnCanibal(itemStack, player)) {
                if (!world.field_72995_K) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, this.getPowerDuration(itemStack) * 20, 1));
                }
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187863_gH, SoundCategory.HOSTILE, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            } else if (this.isPower()) {
                int foodLevel = this.func_150905_g(itemStack);
                float saturationLevel = this.func_150906_h(itemStack);
                player.func_71024_bL().func_75122_a(foodLevel, saturationLevel);
                if (!world.field_72995_K) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, this.getPowerDuration(itemStack) * 20, 2));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, this.getPowerDuration(itemStack) * 20, 2));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, this.getPowerDuration(itemStack) * 20, 2));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, this.getPowerDuration(itemStack) * 20, 2));
                }
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_189111_gN, SoundCategory.HOSTILE, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            } else {
                if (!world.field_72995_K) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 1));
                }
                world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187863_gH, SoundCategory.HOSTILE, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.func_77849_c(itemStack, world, player);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack(item, 1, 0));
        list.add((Object)new ItemStack(item, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (this.isHumanFlesh(itemStack)) {
            String player = TextFormatting.ITALIC + "None";
            if (itemStack.func_77978_p() != null) {
                GameProfile profile = NBTUtil.func_152459_a((NBTTagCompound)itemStack.func_77978_p());
                player = profile.getName();
            }
            list.add("Player: " + TextFormatting.WHITE + player);
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColorHandler() {
        return new ItemColor();
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int func_186726_a(ItemStack itemStack, int renderPass) {
            if (WerewolfFlesh.getInstance().isHumanFlesh(itemStack)) {
                return Helpers.RGBToInt((int)255, (int)200, (int)180);
            }
            return -1;
        }
    }
}

