/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.block.DarkTank;

public class TileDarkTank
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final int BASE_CAPACITY = 16000;
    public static final String NBT_TAG_TANK = "darkTank";
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);

    public TileDarkTank() {
        super(0, "inventory", 16000, NBT_TAG_TANK);
        this.setSendUpdateOnTankChanged(true);
    }

    public boolean func_94041_b(int index, ItemStack item) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public double getFillRatio() {
        return Math.min(1.0, (double)this.getTank().getFluidAmount() / (double)this.getTank().getCapacity());
    }

    protected boolean shouldAutoDrain() {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IBlockState)this.field_145850_b.func_180495_p(this.func_174877_v()), (IProperty)DarkTank.DRAINING, (Object)false);
    }

    protected void updateTileEntity() {
        if (!this.func_145831_w().field_72995_K && !this.getTank().isEmpty() && this.shouldAutoDrain()) {
            EnumFacing down = EnumFacing.DOWN;
            IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(down), (EnumFacing)down.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (handler != null) {
                FluidStack fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount()));
                if (handler.fill(fluidStack, false) > 0) {
                    int filled = handler.fill(fluidStack, true);
                    this.drain(filled, true);
                }
            } else {
                List entities = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177972_a(down), this.func_174877_v().func_177972_a(down).func_177982_a(1, 1, 1)), EntitySelectors.field_94557_a);
                for (Entity entity : entities) {
                    if (!this.getTank().isEmpty() && entity instanceof EntityItem) {
                        ItemStack itemStack;
                        ItemStack fillItemStack;
                        EntityItem item = (EntityItem)entity;
                        if (item.func_92059_d() == null || !item.func_92059_d().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || item.func_92059_d().func_190916_E() != 1 || (fillItemStack = this.fill(itemStack = item.func_92059_d().func_77946_l())) == null) continue;
                        item.func_92058_a(fillItemStack);
                        continue;
                    }
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
                    while (!this.getTank().isEmpty() && it.hasNext()) {
                        ItemStack fillItemStack;
                        ItemStack itemStack = it.next();
                        if (itemStack.func_190926_b() || !itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) || (fillItemStack = this.fill(itemStack)) == null) continue;
                        it.replace(fillItemStack);
                    }
                }
            }
        }
    }

    protected ItemStack fill(ItemStack itemStack) {
        FluidStack fluidStack;
        ItemStack fillItemStack = itemStack.func_77946_l();
        IFluidHandler container = (IFluidHandler)fillItemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (container.fill(fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount())), false) > 0) {
            int filled = container.fill(fluidStack, true);
            this.drain(filled, true);
            return fillItemStack;
        }
        return null;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

