/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.block.EnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.client.particle.ExtendedParticleBubble;
import org.cyclops.evilcraft.client.particle.ParticleTargettedBlur;
import org.cyclops.evilcraft.core.degradation.DegradationExecutor;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.tileentity.EvilCraftBeaconTileEntity;
import org.cyclops.evilcraft.tileentity.environmentalaccumulator.IEAProcessingFinishedEffect;
import org.lwjgl.util.vector.Vector4f;

public class TileEnvironmentalAccumulator
extends EvilCraftBeaconTileEntity
implements IDegradable,
IInventory {
    public static final int MAX_AGE = 50;
    public static final int SPREAD = 25;
    private static final int ITEM_MOVE_COOLDOWN_DURATION = 1;
    private static final double WEATHER_CONTAINER_MIN_DROP_HEIGHT = 0.0;
    private static final double WEATHER_CONTAINER_MAX_DROP_HEIGHT = 2.0;
    private static final double WEATHER_CONTAINER_SPAWN_HEIGHT = (double)EnvironmentalAccumulatorConfig.defaultProcessItemTickCount * EnvironmentalAccumulatorConfig.defaultProcessItemSpeed + 1.0;
    private static final float ITEM_MIN_SPAWN_HEIGHT = 1.0f;
    private static final int DEGRADATION_RADIUS_BASE = 5;
    private static final int DEGRADATION_TICK_INTERVAL = 100;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private DegradationExecutor degradationExecutor;
    private int degradation = 0;
    private BlockPos location = null;
    private static final BlockPos[] waterOffsets = new BlockPos[]{new BlockPos(-2, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(2, -1, 2)};
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private int state = 0;
    private int tick = 0;
    private SimpleInventory inventory;
    private IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe;

    public TileEnvironmentalAccumulator() {
        this.degradationExecutor = new DegradationExecutor(this);
        this.inventory = new SimpleInventory(1, EnvironmentalAccumulatorConfig._instance.getNamedId(), 64);
        if (MinecraftHelpers.isClientSide()) {
            this.setBeamInnerColor(this.getInnerColorByState(this.state));
            this.setBeamOuterColor(this.getOuterColorByState(this.state));
        }
    }

    protected Triple<Float, Float, Float> getBaseBeamColor() {
        if (this.func_145831_w() == null) {
            return Triple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        Biome biome = this.func_145831_w().func_180494_b(this.func_174877_v());
        return Helpers.intToRGB((int)biome.func_180625_c(this.func_174877_v()));
    }

    @SideOnly(value=Side.CLIENT)
    private Vector4f getInnerColorByState(int state) {
        Triple<Float, Float, Float> baseColor = this.getBaseBeamColor();
        float coolFactor = (float)(this.getMaxCooldownTick() - this.tick) / (float)this.getMaxCooldownTick();
        if (state == 1) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.05f);
        }
        if (state == 0) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue(), ((Float)baseColor.getMiddle()).floatValue(), ((Float)baseColor.getRight()).floatValue(), 0.13f);
        }
        return new Vector4f(((Float)baseColor.getLeft()).floatValue() * coolFactor, ((Float)baseColor.getMiddle()).floatValue() * coolFactor, ((Float)baseColor.getRight()).floatValue() * coolFactor, 0.13f);
    }

    @SideOnly(value=Side.CLIENT)
    private Vector4f getOuterColorByState(int state) {
        Triple<Float, Float, Float> baseColor = this.getBaseBeamColor();
        float coolFactor = (float)(this.getMaxCooldownTick() - this.tick) / (float)this.getMaxCooldownTick() / 2.0f;
        if (state == 2) {
            return new Vector4f(((Float)baseColor.getLeft()).floatValue() * coolFactor, ((Float)baseColor.getMiddle()).floatValue() * coolFactor, ((Float)baseColor.getRight()).floatValue() * coolFactor, 0.13f);
        }
        return new Vector4f(((Float)baseColor.getLeft()).floatValue() / 2.0f, ((Float)baseColor.getMiddle()).floatValue() / 2.0f, ((Float)baseColor.getRight()).floatValue() / 2.0f, 0.13f);
    }

    public int getMaxCooldownTick() {
        EnvironmentalAccumulatorRecipeProperties result;
        EnvironmentalAccumulatorRecipeProperties environmentalAccumulatorRecipeProperties = result = this.recipe == null ? null : (EnvironmentalAccumulatorRecipeProperties)this.recipe.getProperties();
        if (result == null) {
            return EnvironmentalAccumulatorConfig.defaultTickCooldown;
        }
        return result.getCooldownTime();
    }

    @SideOnly(value=Side.CLIENT)
    public float getMovingItemY() {
        if (this.state == 1) {
            return 1.0f + (float)(this.getItemMoveDuration() - this.tick) * this.getItemMoveSpeed();
        }
        return -1.0f;
    }

    public IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getRecipe() {
        return this.recipe;
    }

    private int getItemMoveDuration() {
        if (this.recipe == null) {
            return EnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return ((EnvironmentalAccumulatorRecipeProperties)this.recipe.getProperties()).getDuration();
    }

    private float getItemMoveSpeed() {
        if (this.recipe == null) {
            return (float)EnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return (float)((EnvironmentalAccumulatorRecipeProperties)this.recipe.getProperties()).getProcessingSpeed();
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.tick > 0) {
            --this.tick;
        }
        if (this.state == 0) {
            this.updateEnvironmentalAccumulatorIdle();
        } else if (this.state == 1) {
            if (this.field_145850_b.field_72995_K) {
                this.showWaterBeams();
                if (this.tick > 50) {
                    this.showAccumulatingParticles();
                }
            }
            if (this.tick == 0) {
                this.dropItemStack();
                this.activateFinishedProcessingItemState();
            }
        } else if (this.state == 3) {
            if (this.tick == 0) {
                this.activateCooldownState();
                this.func_70298_a(0, this.func_70297_j_());
            }
        } else if (this.state == 2) {
            this.setBeamColors(this.state);
            this.degradationExecutor.runRandomEffect(this.field_145850_b.field_72995_K);
            if (this.tick == 0) {
                this.activateIdleState();
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.getBossInfo().func_186735_a(this.getHealth() / this.getMaxHealth());
            HashSet playerIds = Sets.newHashSet();
            if (this.getHealth() != this.getMaxHealth()) {
                for (EntityPlayer player : this.func_145831_w().func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(32.0))) {
                    this.getBossInfo().func_186760_a((EntityPlayerMP)player);
                    playerIds.add(player.func_145782_y());
                }
            }
            ArrayList players = Lists.newArrayList((Iterable)this.getBossInfo().func_186757_c());
            for (EntityPlayerMP playerMP : players) {
                if (playerIds.contains(playerMP.func_145782_y()) && this.getHealth() != 0.0f) continue;
                this.getBossInfo().func_186761_b(playerMP);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showWaterBeams() {
        Random random = this.field_145850_b.field_73012_v;
        BlockPos target = this.func_174877_v();
        for (int j = 0; j < waterOffsets.length; ++j) {
            BlockPos offset = waterOffsets[j];
            BlockPos location = target.func_177971_a((Vec3i)offset);
            double x = (double)location.func_177958_n() + 0.5;
            double y = (double)location.func_177956_o() + 0.5;
            double z = (double)location.func_177952_p() + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw((BlockPos)location, (BlockPos)target);
            float rotationPitch = (float)LocationHelpers.getPitch((BlockPos)location, (BlockPos)target);
            for (int i = 0; i < random.nextInt(2); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 2.0;
                double particleMotionX = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * speed * 5.0;
                double particleMotionZ = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new ExtendedParticleBubble(this.field_145850_b, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ, 0.02));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showAccumulatingParticles() {
        TileEnvironmentalAccumulator.showAccumulatingParticles(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 25.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void showAccumulatingParticles(World world, double centerX, double centerY, double centerZ, double spread) {
        Random rand = world.field_73012_v;
        for (int j = 0; j < rand.nextInt(20); ++j) {
            float scale = 0.6f - rand.nextFloat() * 0.4f;
            float red = rand.nextFloat() * 0.1f + 0.2f;
            float green = rand.nextFloat() * 0.1f + 0.3f;
            float blue = rand.nextFloat() * 0.1f + 0.2f;
            float ageMultiplier = 60.0f;
            double motionX = spread - rand.nextDouble() * 2.0 * spread;
            double motionY = spread - rand.nextDouble() * 2.0 * spread;
            double motionZ = spread - rand.nextDouble() * 2.0 * spread;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new ParticleTargettedBlur(world, scale, motionX, motionY, motionZ, red, green, blue, ageMultiplier, centerX, centerY, centerZ));
        }
    }

    private void updateEnvironmentalAccumulatorIdle() {
        List entityItems = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.0, (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 2.0, (double)this.func_174877_v().func_177952_p() + 1.0));
        for (IRecipe recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().allRecipes()) {
            EnvironmentalAccumulatorRecipeComponent input = (EnvironmentalAccumulatorRecipeComponent)recipe.getInput();
            ItemStack recipeStack = input.getItemStack();
            WeatherType weatherType = input.getWeatherType();
            for (Object obj : entityItems) {
                EntityItem entityItem = (EntityItem)obj;
                ItemStack stack = entityItem.func_92059_d();
                if (recipeStack.func_77973_b() != stack.func_77973_b() || recipeStack.func_77952_i() != stack.func_77952_i() || recipeStack.func_190916_E() > stack.func_190916_E() || weatherType != null && !weatherType.isActive(this.field_145850_b)) continue;
                this.func_70299_a(0, stack.func_77946_l());
                this.recipe = recipe;
                if (!this.field_145850_b.field_72995_K) {
                    this.decreaseStackSize(entityItem, recipeStack);
                }
                this.activateProcessingItemState();
                return;
            }
        }
    }

    private void decreaseStackSize(EntityItem entityItem, ItemStack stack) {
        entityItem.func_92059_d().func_190918_g(stack.func_190916_E());
        if (entityItem.func_92059_d().func_190916_E() == 0) {
            entityItem.func_70106_y();
        }
    }

    private void dropItemStack() {
        if (!this.field_145850_b.field_72995_K) {
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + WEATHER_CONTAINER_SPAWN_HEIGHT, (double)this.func_174877_v().func_177952_p());
            if (this.recipe == null) {
                entity.func_92058_a(this.func_70301_a(0));
            } else {
                WeatherType weatherResult;
                entity.func_92058_a(((EnvironmentalAccumulatorRecipeProperties)this.recipe.getProperties()).getResultOverride().getResult((IBlockAccess)this.func_145831_w(), this.func_174877_v(), ((EnvironmentalAccumulatorRecipeComponent)this.recipe.getOutput()).getConditionalItemStack(this.func_70301_a(0))));
                WeatherType weatherSource = ((EnvironmentalAccumulatorRecipeComponent)this.recipe.getInput()).getWeatherType();
                if (weatherSource != null) {
                    weatherSource.deactivate(this.field_145850_b);
                }
                if ((weatherResult = ((EnvironmentalAccumulatorRecipeComponent)this.recipe.getOutput()).getWeatherType()) != null) {
                    weatherResult.activate(this.field_145850_b);
                }
            }
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    private void activateIdleState() {
        this.tick = 0;
        this.state = 0;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    private void activateProcessingItemState() {
        this.tick = this.recipe == null ? EnvironmentalAccumulatorConfig.defaultProcessItemTickCount : ((EnvironmentalAccumulatorRecipeProperties)this.recipe.getProperties()).getDuration();
        this.state = 1;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    private void activateFinishedProcessingItemState() {
        this.tick = 1;
        this.state = 3;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    private void activateCooldownState() {
        ++this.degradation;
        this.degradationExecutor.setTickInterval(100 / this.degradation);
        this.tick = this.getMaxCooldownTick();
        this.state = 2;
        this.recipe = null;
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdate();
        }
    }

    public void onUpdateReceived() {
        if (this.field_145850_b.field_72995_K && this.state == 3) {
            IEAProcessingFinishedEffect effect;
            IEAProcessingFinishedEffect iEAProcessingFinishedEffect = effect = this.recipe == null ? null : ((EnvironmentalAccumulatorRecipeProperties)this.recipe.getProperties()).getFinishedProcessingEffect();
            if (effect == null) {
                this.field_145850_b.func_175669_a(2002, this.func_174877_v().func_177963_a(0.0, WEATHER_CONTAINER_SPAWN_HEIGHT, 0.0), 16428);
            } else {
                effect.executeEffect(this, this.recipe);
            }
        }
        this.setBeamColors(this.state);
    }

    public void setBeamColors(int state) {
        if (this.field_145850_b.field_72995_K) {
            this.setBeamInnerColor(this.getInnerColorByState(state));
            this.setBeamOuterColor(this.getOuterColorByState(state));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.degradation = compound.func_74762_e("degradation");
        this.tick = compound.func_74762_e("tick");
        this.state = compound.func_74762_e("state");
        String recipeId = compound.func_74779_i("recipe");
        if (recipeId != null) {
            this.recipe = EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipeByNamedId(recipeId);
        }
        this.degradationExecutor.readFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        String recipeId;
        tag = super.func_189515_b(tag);
        tag.func_74768_a("degradation", this.degradation);
        tag.func_74768_a("tick", this.tick);
        tag.func_74768_a("state", this.state);
        String string = recipeId = this.recipe == null ? null : this.recipe.getNamedId();
        if (recipeId != null) {
            tag.func_74778_a("recipe", recipeId);
        }
        this.degradationExecutor.writeToNBT(tag);
        return tag;
    }

    public float getMaxHealth() {
        if (this.state == 1) {
            return this.getItemMoveDuration();
        }
        if (this.state == 3) {
            return 0.0f;
        }
        return this.getMaxCooldownTick();
    }

    public float getHealth() {
        if (this.state == 1) {
            return this.tick;
        }
        if (this.state == 2) {
            return this.getMaxCooldownTick() - this.tick;
        }
        return this.getMaxCooldownTick();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        String message = L10NHelpers.localize((String)"chat.evilcraft.boss_display.charge", (Object[])new Object[]{L10NHelpers.localize((String)(EnvironmentalAccumulator.getInstance().func_149739_a() + ".name"), (Object[])new Object[0])});
        return new TextComponentString(message);
    }

    @Override
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    public int getRadius() {
        return 5 + this.degradation / 10;
    }

    @Override
    public List<Entity> getAreaEntities() {
        return EntityHelpers.getEntitiesInArea((World)this.getDegradationWorld(), (BlockPos)this.func_174877_v(), (int)this.getRadius());
    }

    @Override
    public double getDegradation() {
        return this.degradation;
    }

    @Override
    public World getDegradationWorld() {
        return this.func_145831_w();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.func_70302_i_() || i < 0) {
            return ItemStack.field_190927_a;
        }
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public void func_174889_b(EntityPlayer playerIn) {
        this.inventory.func_174889_b(playerIn);
    }

    public void func_174886_c(EntityPlayer playerIn) {
        this.inventory.func_174886_c(playerIn);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inventory.func_94041_b(i, itemstack);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public BossInfoServer getBossInfo() {
        return this.bossInfo;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

