/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.block.SanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.client.particle.ParticleBloodBubble;
import org.cyclops.evilcraft.core.fluid.VirtualTank;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.tileentity.TileEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.TileWorking;
import org.cyclops.evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;

public class TileSanguinaryEnvironmentalAccumulator
extends TileWorking<TileSanguinaryEnvironmentalAccumulator, MutableInt>
implements VirtualTank.ITankProvider {
    public static final int SLOTS = 2;
    public static final int SLOT_ACCUMULATE = 0;
    public static final int SLOT_ACCUMULATE_RESULT = 1;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private static final int TANK_CHECK_TICK_OFFSET = 60;
    private int accumulateTicker;
    private SingleCache<Triple<ItemStack, FluidStack, WeatherType>, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>> recipeCache;
    private VirtualTank virtualTank;
    private boolean forceLoadTanks;
    private List<BlockPos> invalidLocations = Lists.newArrayList();
    private static final Map<Class<?>, ITickAction<TileSanguinaryEnvironmentalAccumulator>> ACCUMULATE_TICK_ACTIONS = new LinkedHashMap();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private static final BlockPos[] tankOffsets;

    public TileSanguinaryEnvironmentalAccumulator() {
        super(2, SanguinaryEnvironmentalAccumulator.getInstance().func_149732_F(), 0, "", ACCEPTED_FLUID);
        this.accumulateTicker = this.addTicker(new TickComponent<TileSanguinaryEnvironmentalAccumulator, ITickAction<TileSanguinaryEnvironmentalAccumulator>>(this, ACCUMULATE_TICK_ACTIONS, 0));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        outSlots.add(1);
        this.addSlotsToSide(EnumFacing.EAST, inSlots);
        this.addSlotsToSide(EnumFacing.UP, inSlots);
        this.addSlotsToSide(EnumFacing.NORTH, inSlots);
        this.addSlotsToSide(EnumFacing.DOWN, outSlots);
        this.addSlotsToSide(EnumFacing.SOUTH, outSlots);
        this.addSlotsToSide(EnumFacing.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSanguinaryEnvironmentalAccumulator, MutableInt>(2.0){

            @Override
            public void applyUpgrade(TileSanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileSanguinaryEnvironmentalAccumulator, MutableInt>(1.0){

            @Override
            public void applyUpgrade(TileSanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, FluidStack, WeatherType>, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>>(){

            public IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getNewValue(Triple<ItemStack, FluidStack, WeatherType> key) {
                EnvironmentalAccumulatorRecipeComponent recipeInput = new EnvironmentalAccumulatorRecipeComponent((ItemStack)key.getLeft(), (WeatherType)key.getRight());
                for (IRecipe recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipesByInput((IRecipeInput)recipeInput)) {
                    if (!((EnvironmentalAccumulatorRecipeComponent)recipe.getInput()).getWeatherType().isActive(TileSanguinaryEnvironmentalAccumulator.this.field_145850_b)) continue;
                    return recipe;
                }
                return null;
            }

            public boolean isKeyEqual(Triple<ItemStack, FluidStack, WeatherType> cacheKey, Triple<ItemStack, FluidStack, WeatherType> newKey) {
                return cacheKey == null || newKey == null || ItemStack.func_77989_b((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getMiddle()), (FluidStack)((FluidStack)newKey.getMiddle())) && cacheKey.getRight() == newKey.getRight();
            }
        });
        this.virtualTank = new VirtualTank(this, true);
        this.forceLoadTanks = true;
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new SingleUseTank("noTank", 0, (CyclopsTileEntity)this);
    }

    public IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getRecipe(ItemStack itemStack) {
        return (IRecipe)this.recipeCache.get((Object)new ImmutableTriple((Object)(itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l()), (Object)(this.getTank().getFluid() == null ? null : this.getTank().getFluid().copy()), (Object)WeatherType.getActiveWeather(this.field_145850_b)));
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b.field_72995_K && this.isVisuallyWorking()) {
            this.showTankBeams();
            if (this.getRequiredWorkTicks() - (float)this.getWorkTick() > 50.0f) {
                this.showAccumulatingParticles();
            }
        } else if (this.field_145850_b.field_72995_K && !this.canWork()) {
            this.showMissingTanks();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showAccumulatingParticles() {
        TileEnvironmentalAccumulator.showAccumulatingParticles(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 25.0);
    }

    @SideOnly(value=Side.CLIENT)
    protected void showTankBeams() {
        Random random = this.field_145850_b.field_73012_v;
        BlockPos target = this.func_174877_v();
        for (int j = 0; j < tankOffsets.length; ++j) {
            BlockPos offset = tankOffsets[j];
            BlockPos location = target.func_177971_a((Vec3i)offset);
            double x = (double)location.func_177958_n() + 0.5;
            double y = (double)location.func_177956_o() + 0.5;
            double z = (double)location.func_177952_p() + 0.5;
            float rotationYaw = (float)LocationHelpers.getYaw((BlockPos)location, (BlockPos)target);
            float rotationPitch = (float)LocationHelpers.getPitch((BlockPos)location, (BlockPos)target);
            for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 0.5;
                double particleMotionX = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * -speed;
                double particleMotionZ = (double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new ParticleBloodBubble(this.field_145850_b, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void showMissingTanks() {
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            Random random = this.field_145850_b.field_73012_v;
            for (BlockPos location : this.invalidLocations) {
                double x = (double)location.func_177958_n() + 0.5;
                double y = (double)location.func_177956_o() + 0.5;
                double z = (double)location.func_177952_p() + 0.5;
                for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                    double particleX = x - 0.2 + random.nextDouble() * 0.4;
                    double particleY = y - 0.2 + random.nextDouble() * 0.4;
                    double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                    FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(new ParticleSmokeNormal.Factory().func_178902_a(0, this.field_145850_b, particleX, particleY, particleZ, 0.0, 0.0, 0.0, new int[0]));
                }
            }
        }
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe = this.getRecipe(itemStack);
        return recipe != null;
    }

    public int getConsumeSlot() {
        return 0;
    }

    public int getProduceSlot() {
        return 1;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack) {
        return slot != this.getProduceSlot() && super.canInsertItem(slot, itemStack);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return this.canConsume(itemStack);
        }
        return super.func_94041_b(slot, itemStack);
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)SanguinaryEnvironmentalAccumulator.ON, (Comparable)Boolean.valueOf(this.isWorking()));
        this.field_145850_b.func_175656_a(this.func_174877_v(), blockState);
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    @Override
    public boolean canWork() {
        if (!this.forceLoadTanks && this.invalidLocations != null && !WorldHelpers.efficientTick((World)this.field_145850_b, (int)60, (BlockPos)this.func_174877_v())) {
            return this.invalidLocations.isEmpty();
        }
        this.forceLoadTanks = false;
        return this.getVirtualTankChildren() != null;
    }

    @Override
    protected int getWorkTicker() {
        return this.accumulateTicker;
    }

    public VirtualTank getVirtualTank() {
        return this.virtualTank;
    }

    @Override
    @Nullable
    public IFluidHandler[] getVirtualTankChildren() {
        IFluidHandler[] tanks = new IFluidHandler[tankOffsets.length];
        this.invalidLocations.clear();
        for (int i = 0; i < tankOffsets.length; ++i) {
            IFluidTankProperties[] info;
            BlockPos offset = tankOffsets[i];
            BlockPos location = this.func_174877_v().func_177971_a((Vec3i)offset);
            IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((World)this.func_145831_w(), (BlockPos)location, (EnumFacing)EnumFacing.UP, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            boolean oneValid = false;
            if (handler != null && (info = handler.getTankProperties()) != null) {
                for (IFluidTankProperties tank : info) {
                    if (tank.getContents() == null || tank.getContents().getFluid() != ACCEPTED_FLUID) continue;
                    oneValid = true;
                    break;
                }
            }
            if (!oneValid) {
                this.invalidLocations.add(location);
            }
            tanks[i] = handler;
        }
        if (!this.invalidLocations.isEmpty()) {
            return null;
        }
        return tanks;
    }

    protected boolean isUpdateInventoryHashOnTankContentsChanged() {
        return true;
    }

    public List<BlockPos> getInvalidLocations() {
        return this.invalidLocations;
    }

    static {
        ACCUMULATE_TICK_ACTIONS.put(Item.class, new AccumulateItemTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        tankOffsets = new BlockPos[]{new BlockPos(-3, 0, -1), new BlockPos(-3, 0, 1), new BlockPos(3, 0, -1), new BlockPos(3, 0, 1), new BlockPos(-1, 0, -3), new BlockPos(-1, 0, 3), new BlockPos(1, 0, -3), new BlockPos(1, 0, 3)};
    }
}

