/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser;

import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileBloodInfuser;
import org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser.BloodInfuserTickAction;

public class InfuseItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && tile.getTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, this.getRecipe(tile));
    }

    @Override
    public void onTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe = this.getRecipe(tile);
        if (tick >= this.getRequiredTicks(tile, recipe) && recipe != null && this.addToProduceSlot(tile, ((ItemStackRecipeComponent)recipe.getOutput()).getItemStack().func_77946_l())) {
            tile.getInventory().func_70298_a(tile.getConsumeSlot(), 1);
            tile.getTank().drain(this.getRequiredFluidAmount(tile, recipe), true);
        }
    }

    protected int getRequiredFluidAmount(TileBloodInfuser tile, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        if (recipe == null) {
            return Integer.MAX_VALUE;
        }
        MutableInt amount = new MutableInt(((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getFluidStack().amount);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, TileBloodInfuser.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> getRecipe(TileBloodInfuser tile) {
        return tile.getRecipe(this.getInfuseStack(tile));
    }

    @Override
    public int getUnmodifiedRequiredTicks(TileBloodInfuser tile, int slot) {
        return this.getUnmodifiedRequiredTicks(tile, this.getRecipe(tile));
    }

    private int getUnmodifiedRequiredTicks(TileBloodInfuser tile, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        return ((DurationXpRecipeProperties)recipe.getProperties()).getDuration();
    }

    private int getRequiredTicks(TileBloodInfuser tile, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileBloodInfuser.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    @Override
    public ItemStack willProduceItem(TileBloodInfuser tile) {
        IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe = this.getRecipe(tile);
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        return ((ItemStackRecipeComponent)recipe.getOutput()).getItemStack();
    }
}

