/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.bloodmagic;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraftcompat.modcompat.bloodmagic.BoundBloodDropConfig;
import org.cyclops.evilcraftcompat.modcompat.bloodmagic.ClientSoulNetworkHandler;

public class BoundBloodDrop
extends ConfigurableDamageIndicatedItemFluidContainer
implements IBindable {
    private static BoundBloodDrop _instance = null;

    public static BoundBloodDrop getInstance() {
        return _instance;
    }

    public BoundBloodDrop(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 1000, (Fluid)Blood.getInstance());
        this.setPlaceFluids(true);
    }

    public String getOwnerName(ItemStack item) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74779_i("ownerNAME");
    }

    public String getOwnerUUID(ItemStack item) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        return item.func_77978_p().func_74779_i("ownerUUID");
    }

    public boolean onBind(EntityPlayer player, ItemStack stack) {
        return true;
    }

    private static int getCurrentEssence(String uuid) {
        return ClientSoulNetworkHandler.getInstance().getCurrentEssence(uuid);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        itemList.add((Object)new ItemStack((Item)this));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo((List)list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.auto_supply"));
        if (itemStack.func_77978_p() != null) {
            String owner = this.getOwnerName(itemStack);
            if (owner == null || owner.isEmpty()) {
                owner = TextFormatting.ITALIC + L10NHelpers.localize((String)(this.func_77658_a() + ".info.current_owner.none"), (Object[])new Object[0]);
            }
            list.add(L10NHelpers.localize((String)(this.func_77658_a() + ".info.current_owner"), (Object[])new Object[]{owner}));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemHelpers.toggleActivation(itemStack);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill(FluidUtil.getFluidHandler((ItemStack)itemStack), world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandler(stack, 1000);
    }

    public static class FluidHandler
    extends FluidContainerItemWrapperWithSimulation {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity, (Fluid)Blood.getInstance());
        }

        public int getCapacity() {
            FluidStack contents = FluidUtil.getFluidContained((ItemStack)this.container);
            int contentsAmount = contents == null ? 0 : contents.amount;
            return Math.max(contentsAmount, BoundBloodDropConfig.maxCapacity);
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            int filled;
            doFill = this.shouldDoFill(resource, doFill);
            String uuid = BoundBloodDrop.getInstance().getOwnerUUID(this.container);
            if (uuid == null || uuid.isEmpty()) {
                return 0;
            }
            int essence = BoundBloodDrop.getCurrentEssence(uuid);
            FluidStack essenceFluid = BloodFluidConverter.getInstance().convertReverse(BloodMagicAPI.getLifeEssence(), resource);
            int n = filled = essenceFluid == null ? 0 : essenceFluid.amount;
            if (doFill && !MinecraftHelpers.isClientSide()) {
                NetworkHelper.getSoulNetwork((String)uuid).setCurrentEssence(essence + filled);
            }
            return filled;
        }

        @Override
        public FluidStack drain(int maxDrain, boolean doDrain) {
            String uuid = BoundBloodDrop.getInstance().getOwnerUUID(this.container);
            if (uuid == null || uuid.isEmpty()) {
                return null;
            }
            int essence = BoundBloodDrop.getCurrentEssence(uuid);
            FluidStack toDrain = new FluidStack((Fluid)Blood.getInstance(), maxDrain);
            FluidStack toDrainEssence = BloodFluidConverter.getInstance().convertReverse(BloodMagicAPI.getLifeEssence(), toDrain);
            int drainEssence = Math.min(essence, toDrainEssence == null ? 0 : toDrainEssence.amount);
            if (doDrain && !MinecraftHelpers.isClientSide()) {
                NetworkHelper.getSoulNetwork((String)uuid).setCurrentEssence(essence - drainEssence);
            }
            FluidStack drainedEssence = new FluidStack(BloodMagicAPI.getLifeEssence(), drainEssence);
            return this.wrapSimulatedDrained(BloodFluidConverter.getInstance().convert(drainedEssence), doDrain);
        }

        @Override
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            doDrain = this.shouldDoDrain(resource, doDrain);
            if (resource != null && this.canDrainFluidType(resource)) {
                return this.drain(resource.amount, doDrain);
            }
            return null;
        }
    }
}

