/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.block.BloodInfuser;
import org.cyclops.evilcraft.item.Promise;
import org.cyclops.evilcraft.tileentity.TileWorking;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeJEI;

public class BloodInfuserRecipeCategory
implements IRecipeCategory {
    private static final int INPUT_SLOT = 0;
    private static final int UPGRADE_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int FLUID_SLOT = 3;
    private final IDrawable background;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public BloodInfuserRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("evilcraft:" + BloodInfuser.getInstance().getGuiTexture("_jei"));
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    @Nonnull
    public String getUid() {
        return "evilcraft:bloodInfuser";
    }

    @Nonnull
    public String getTitle() {
        return L10NHelpers.localize((String)(BloodInfuser.getInstance().func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 65, 28);
    }

    protected int getMaxTankSize(BloodInfuserRecipeJEI bloodInfuserRecipe) {
        return 10000 * TileWorking.getTankTierMultiplier(bloodInfuserRecipe.getUpgrade());
    }

    protected ItemStack getPromise(BloodInfuserRecipeJEI bloodInfuserRecipe) {
        if (bloodInfuserRecipe.getUpgrade() == 0) {
            return null;
        }
        return new ItemStack((Item)Promise.getInstance(), 1, bloodInfuserRecipe.getUpgrade() - 1);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 41, 27);
        recipeLayout.getItemStacks().init(1, false, 41, 7);
        recipeLayout.getItemStacks().init(2, false, 95, 27);
        if (recipeWrapper instanceof BloodInfuserRecipeJEI) {
            BloodInfuserRecipeJEI recipe = (BloodInfuserRecipeJEI)recipeWrapper;
            recipeLayout.getItemStacks().set(0, recipe.getInput());
            recipeLayout.getItemStacks().set(1, this.getPromise(recipe));
            recipeLayout.getItemStacks().set(2, recipe.getOutput());
            recipeLayout.getFluidStacks().init(3, true, 6, 6, 16, 58, this.getMaxTankSize(recipe), true, this.tankOverlay);
            recipeLayout.getFluidStacks().set(3, recipe.getFluidStack());
        }
    }
}

