/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.displaystand;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.evilcraft.block.DisplayStand;
import org.cyclops.evilcraft.core.recipe.DisplayStandRecipe;

public class DisplayStandRecipeJEI
extends ShapedOreRecipeWrapper {
    private final List<ItemStack> outputs;
    private final IJeiHelpers jeiHelpers;
    private final ShapedOreRecipe recipe;

    public DisplayStandRecipeJEI(IJeiHelpers jeiHelpers, DisplayStandRecipe recipe) {
        super(jeiHelpers, (ShapedOreRecipe)recipe);
        this.jeiHelpers = jeiHelpers;
        this.recipe = recipe;
        this.outputs = Lists.newArrayList();
        for (ItemStack plankWoodStack : OreDictionary.getOres((String)"plankWood")) {
            int plankWoodMeta = plankWoodStack.func_77952_i();
            if (plankWoodMeta == Short.MAX_VALUE) {
                NonNullList plankWoodSubItems = NonNullList.func_191196_a();
                plankWoodStack.func_77973_b().func_150895_a(plankWoodStack.func_77973_b(), null, plankWoodSubItems);
                for (ItemStack plankWoodSubItem : plankWoodSubItems) {
                    IBlockState plankWoodBlockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)plankWoodSubItem);
                    this.outputs.add(DisplayStand.getInstance().getTypedDisplayStandItem(plankWoodBlockState));
                }
                continue;
            }
            IBlockState plankWoodBlockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)plankWoodStack);
            this.outputs.add(DisplayStand.getInstance().getTypedDisplayStandItem(plankWoodBlockState));
        }
    }

    public void getIngredients(IIngredients ingredients) {
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        List inputs = stackHelper.expandRecipeItemStackInputs(Arrays.asList(this.recipe.getInput()));
        ingredients.setInputLists(ItemStack.class, inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayStandRecipeJEI)) {
            return false;
        }
        DisplayStandRecipeJEI other = (DisplayStandRecipeJEI)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<ItemStack> this$outputs = this.getOutputs();
        List<ItemStack> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        IJeiHelpers this$jeiHelpers = this.getJeiHelpers();
        IJeiHelpers other$jeiHelpers = other.getJeiHelpers();
        if (this$jeiHelpers == null ? other$jeiHelpers != null : !this$jeiHelpers.equals(other$jeiHelpers)) {
            return false;
        }
        ShapedOreRecipe this$recipe = this.getRecipe();
        ShapedOreRecipe other$recipe = other.getRecipe();
        return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DisplayStandRecipeJEI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ItemStack> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 0 : ((Object)$outputs).hashCode());
        IJeiHelpers $jeiHelpers = this.getJeiHelpers();
        result = result * 59 + ($jeiHelpers == null ? 0 : $jeiHelpers.hashCode());
        ShapedOreRecipe $recipe = this.getRecipe();
        result = result * 59 + ($recipe == null ? 0 : $recipe.hashCode());
        return result;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    public ShapedOreRecipe getRecipe() {
        return this.recipe;
    }

    public String toString() {
        return "DisplayStandRecipeJEI(outputs=" + this.getOutputs() + ", jeiHelpers=" + this.getJeiHelpers() + ", recipe=" + this.getRecipe() + ")";
    }
}

