/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.tileentity;

import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.tileentity.TilePurifier;
import org.cyclops.evilcraft.tileentity.tickaction.purifier.DisenchantPurifyAction;
import org.lwjgl.opengl.GL11;

public class RenderTileEntityPurifier
extends TileEntitySpecialRenderer<TilePurifier> {
    private static final ResourceLocation TEXTURE_BLOOK = new ResourceLocation("evilcraft", "textures/entities/blook.png");
    private static final ResourceLocation TEXTURE_ENCHANTEDBOOK = new ResourceLocation("evilcraft", "textures/entities/enchanted_book.png");
    private ModelBook enchantmentBook = new ModelBook();

    public void render(TilePurifier tile, double x, double y, double z, float partialTickTime, int partialDamage, float alpha) {
        ItemStack additionalItem;
        if (tile != null && (additionalItem = tile.getAdditionalItem()) != null) {
            if (additionalItem.func_77973_b() == DisenchantPurifyAction.ALLOWED_BOOK.get() || additionalItem.func_77973_b() == Items.field_151134_bR) {
                this.renderBook(tile, tile.func_145831_w(), additionalItem, x, y + 0.4, z, partialTickTime);
            } else {
                this.renderAdditionalItem(tile, tile.func_145831_w(), additionalItem, x, y + 0.4, z, partialTickTime);
            }
        }
        GlStateManager.func_179094_E();
        float var10 = (float)(x - 0.5);
        float var11 = (float)(y - 0.5);
        float var12 = (float)(z - 0.5);
        GlStateManager.func_179109_b((float)var10, (float)var11, (float)var12);
        if (tile != null && tile.getPurifyItem() != null) {
            this.renderItem(tile.func_145831_w(), tile.getPurifyItem(), tile.getRandomRotation());
        }
        GlStateManager.func_179121_F();
    }

    private void renderItem(World world, ItemStack itemStack, float rotation) {
        GlStateManager.func_179094_E();
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            GlStateManager.func_179109_b((float)1.0f, (float)1.2f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
        } else {
            GlStateManager.func_179109_b((float)1.0f, (float)1.2f, (float)1.0f);
            GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        RenderHelpers.renderItem((ItemStack)itemStack);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderAdditionalItem(TilePurifier tile, World world, ItemStack itemStack, double x, double y, double z, float partialTickTime) {
        float speedUp;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        GL11.glTranslatef((float)0.0f, (float)(0.1f + MathHelper.func_76126_a((float)(tick * 0.1f)) * 0.01f), (float)0.0f);
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            GL11.glTranslatef((float)1.0f, (float)0.675f, (float)1.0f);
        }
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        GL11.glRotatef((float)(-rotation * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
            GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        RenderHelpers.renderItem((ItemStack)itemStack);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GL11.glPopMatrix();
    }

    private void renderBook(TilePurifier tile, World world, ItemStack itemStack, double x, double y, double z, float partialTickTime) {
        float speedUp;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        GlStateManager.func_179109_b((float)0.0f, (float)(0.1f + MathHelper.func_76126_a((float)(tick * 0.1f)) * 0.01f), (float)0.0f);
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        GlStateManager.func_179114_b((float)(-rotation * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (itemStack.func_77973_b() == DisenchantPurifyAction.ALLOWED_BOOK.get()) {
            this.func_147499_a(TEXTURE_BLOOK);
        } else {
            this.func_147499_a(TEXTURE_ENCHANTEDBOOK);
        }
        GlStateManager.func_179089_o();
        this.enchantmentBook.func_78088_a(null, tick, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
    }
}

