/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPartModelBaked
extends DynamicItemAndBlockModel {
    private final Map<IBroomPart, IBakedModel> broomPartModels = Maps.newHashMap();
    private final List<BakedQuad> quads;

    public BroomPartModelBaked() {
        super(true, false);
        this.quads = Collections.emptyList();
    }

    public BroomPartModelBaked(List<BakedQuad> quads) {
        super(false, true);
        this.quads = Objects.requireNonNull(quads);
    }

    public List<BakedQuad> getGeneralQuads() {
        return this.quads;
    }

    public void addBroomPartModel(IBroomPart part, IBakedModel bakedModel) {
        this.broomPartModels.put(part, bakedModel);
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        throw new UnsupportedOperationException();
    }

    public IBakedModel handleItemState(ItemStack itemStack, World world, EntityLivingBase entity) {
        LinkedList quads = Lists.newLinkedList();
        Object part = BroomParts.REGISTRY.getPartFromItem(itemStack);
        IBakedModel model = this.broomPartModels.get(part);
        if (model != null) {
            quads.addAll(this.color(model.func_188616_a(null, this.getRenderingSide(), 0L), part.getModelColor()));
        }
        return new BroomPartModelBaked(quads);
    }

    private Collection<? extends BakedQuad> color(List<BakedQuad> quads, int color) {
        ArrayList offsetQuads = Lists.newArrayListWithExpectedSize((int)quads.size());
        for (BakedQuad quad : quads) {
            int[] vertexData = Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length);
            for (int i = 0; i < vertexData.length / 7; ++i) {
                vertexData[i * 7 + 3] = color;
            }
            offsetQuads.add(new BakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), false, DefaultVertexFormats.field_176599_b));
        }
        return offsetQuads;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BroomPartModelBaked)) {
            return false;
        }
        BroomPartModelBaked other = (BroomPartModelBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map<IBroomPart, IBakedModel> this$broomPartModels = this.getBroomPartModels();
        Map<IBroomPart, IBakedModel> other$broomPartModels = other.getBroomPartModels();
        if (this$broomPartModels == null ? other$broomPartModels != null : !((Object)this$broomPartModels).equals(other$broomPartModels)) {
            return false;
        }
        List<BakedQuad> this$quads = this.getQuads();
        List<BakedQuad> other$quads = other.getQuads();
        return !(this$quads == null ? other$quads != null : !((Object)this$quads).equals(other$quads));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BroomPartModelBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<IBroomPart, IBakedModel> $broomPartModels = this.getBroomPartModels();
        result = result * 59 + ($broomPartModels == null ? 0 : ((Object)$broomPartModels).hashCode());
        List<BakedQuad> $quads = this.getQuads();
        result = result * 59 + ($quads == null ? 0 : ((Object)$quads).hashCode());
        return result;
    }

    public Map<IBroomPart, IBakedModel> getBroomPartModels() {
        return this.broomPartModels;
    }

    public List<BakedQuad> getQuads() {
        return this.quads;
    }

    public String toString() {
        return "BroomPartModelBaked(broomPartModels=" + this.getBroomPartModels() + ", quads=" + this.getQuads() + ")";
    }
}

