/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper.obfuscation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.cyclops.evilcraft.core.helper.obfuscation.ObfuscationData;

public class ObfuscationHelpers {
    public static ResourceLocation getParticleTexture() {
        return (ResourceLocation)ReflectionHelper.getPrivateValue(ParticleManager.class, null, (String[])ObfuscationData.PARTICLE_TEXTURES);
    }

    public static void setRecentlyHit(EntityLivingBase entity, int recentlyHit) {
        ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)entity, (Object)recentlyHit, (String[])ObfuscationData.ENTITYLIVINGBASE_RECENTLYHIT);
    }

    public static SoundEvent getDeathSound(EntityLivingBase entity) {
        Method method = ReflectionHelper.findMethod(EntityLivingBase.class, (String)ObfuscationData.ENTITYLIVINGBASE_GETDEATHSOUND[0], (String)ObfuscationData.ENTITYLIVINGBASE_GETDEATHSOUND[1], (Class[])new Class[0]);
        try {
            return (SoundEvent)method.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public static SoundEvent getAmbientSound(EntityLiving entity) {
        Method method = ReflectionHelper.findMethod(EntityLiving.class, (String)ObfuscationData.ENTITYLIVING_GETAMBIENTSOUND[0], (String)ObfuscationData.ENTITYLIVING_GETAMBIENTSOUND[1], (Class[])new Class[0]);
        try {
            return (SoundEvent)method.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public static void setTitlePanoramaPaths(ResourceLocation[] titlePanoramaPaths) {
        Field field = ReflectionHelper.findField(GuiMainMenu.class, (String[])ObfuscationData.GUIMAINMENU_TITLEPANORAMAPATHS);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            field.set(null, titlePanoramaPaths);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void setPotionEffectDuration(PotionEffect potionEffect, int duration) {
        ReflectionHelper.setPrivateValue(PotionEffect.class, (Object)potionEffect, (Object)duration, (String[])ObfuscationData.POTIONEFFECT_DURATION);
    }

    public static void onChangedPotionEffect(EntityLivingBase entity, PotionEffect potionEffect, boolean reapplyAttributes) {
        Method method = ReflectionHelper.findMethod(EntityLivingBase.class, (String)ObfuscationData.ENTITYLIVINGBASE_ONCHANGEDPOTIONEFFECT[0], (String)ObfuscationData.ENTITYLIVINGBASE_ONCHANGEDPOTIONEFFECT[1], (Class[])new Class[]{PotionEffect.class, Boolean.TYPE});
        try {
            method.invoke((Object)entity, potionEffect, reapplyAttributes);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static ResourceLocation getLootTable(EntityLiving entity) {
        Method method = ReflectionHelper.findMethod(EntityLiving.class, (String)ObfuscationData.ENTITYLIVINGBASE_GETLOOTTABLE[0], (String)ObfuscationData.ENTITYLIVINGBASE_GETLOOTTABLE[1], (Class[])new Class[0]);
        try {
            return (ResourceLocation)method.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public static void setDead(EntityLivingBase entity, boolean dead) {
        ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)entity, (Object)dead, (String[])ObfuscationData.ENTITYLIVINGBASE_DEAD);
    }

    public static Map<Class<Entity>, Integer> getClassToID() {
        return (Map)ReflectionHelper.getPrivateValue(EntityList.class, null, (String[])ObfuscationData.ENTITYLIST_CLASSTOID);
    }

    public static boolean isPotionBadEffect(Potion potion) {
        return (Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)potion, (String[])ObfuscationData.POTION_ISBADEFFECT);
    }

    public static void setPotionTypesArray(Potion[] potionTypes) {
        Field field = ReflectionHelper.findField(Potion.class, (String[])ObfuscationData.POTION_POTIONTYPES);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            field.set(null, potionTypes);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean isRainingEnabled(Biome biome) {
        return (Boolean)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])ObfuscationData.BIOME_ENABLERAIN);
    }
}

