/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe;

import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.block.DarkTank;
import org.cyclops.evilcraft.block.DarkTankConfig;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.item.BloodExtractor;

public class BloodExtractorCombinationRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private int size;

    public BloodExtractorCombinationRecipe(int size) {
        this.size = size;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return !this.func_77572_b(grid).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Item)BloodExtractor.getInstance());
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventory) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        BloodExtractor bloodExtractor = BloodExtractor.getInstance();
        ItemBlockFluidContainer darkTank = (ItemBlockFluidContainer)Item.func_150898_a((Block)DarkTank.getInstance());
        Blood blood = Blood.getInstance();
        int totalCapacity = 0;
        int totalContent = 0;
        int extractors = 0;
        int tanks = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            FluidStack fluidStack;
            ItemStack element = grid.func_70301_a(j);
            if (element.func_190926_b()) continue;
            if (element.func_77973_b() == darkTank) {
                ++tanks;
                fluidStack = FluidUtil.getFluidContained((ItemStack)element);
                if (fluidStack != null) {
                    if (!((Object)((Object)blood)).equals(fluidStack.getFluid())) {
                        return ItemStack.field_190927_a;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.amount);
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element).getCapacity());
                continue;
            }
            if (element.func_77973_b() == bloodExtractor) {
                ++extractors;
                fluidStack = FluidUtil.getFluidContained((ItemStack)element);
                if (fluidStack != null) {
                    if (!((Object)((Object)blood)).equals(fluidStack.getFluid())) {
                        return ItemStack.field_190927_a;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.amount);
                }
                IFluidHandlerItemCapacity fluidHandlerElement = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element);
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)fluidHandlerElement.getCapacity());
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (extractors + tanks < 2 || extractors < 1 || totalCapacity > DarkTankConfig.maxTankSize) {
            return ItemStack.field_190927_a;
        }
        IFluidHandlerItemCapacity fluidHandlerOutput = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)output);
        fluidHandlerOutput.setCapacity(totalCapacity);
        fluidHandlerOutput.fill(new FluidStack((Fluid)blood, totalContent), true);
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.size;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)this.size, (Object)Ingredient.func_193367_a((Item)BloodExtractor.getInstance()));
    }
}

