/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe;

import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.block.DarkTank;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;

public class ItemBlockFluidContainerCombinationRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final int size;
    private final ItemBlockFluidContainer tankItem;
    private final int maxTankSize;

    public ItemBlockFluidContainerCombinationRecipe(int size, ItemBlockFluidContainer tankItem, int maxTankSize) {
        this.size = size;
        this.tankItem = tankItem;
        this.maxTankSize = maxTankSize;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return !this.func_77572_b(grid).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)DarkTank.getInstance());
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventory) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        IFluidHandlerItemCapacity fluidHandlerOutput = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)output);
        FluidStack commonFluid = null;
        int totalCapacity = 0;
        int totalContent = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack element = grid.func_70301_a(j);
            if (element.func_190926_b()) continue;
            if (element.func_77973_b() == this.tankItem) {
                IFluidHandlerItemCapacity fluidHandler = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element);
                ++inputItems;
                FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                if (fluidStack != null) {
                    if (commonFluid == null) {
                        commonFluid = fluidStack;
                    } else if (!commonFluid.equals((Object)fluidStack.getFluid())) {
                        return ItemStack.field_190927_a;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)fluidStack.amount);
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)fluidHandler.getCapacity());
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (inputItems < 2 || totalCapacity > this.maxTankSize) {
            return ItemStack.field_190927_a;
        }
        fluidHandlerOutput.setCapacity(totalCapacity);
        if (commonFluid != null) {
            fluidHandlerOutput.fill(new FluidStack(commonFluid, totalContent), true);
        }
        output = fluidHandlerOutput.getContainer();
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.size;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)this.size, (Object)Ingredient.func_193367_a((Item)this.tankItem));
    }
}

