/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.event.RenderOverlayEventHook;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.item.BroomConfig;

public class Broom
extends ConfigurableDamageIndicatedItemFluidContainer
implements IBroom {
    protected static final ResourceLocation OVERLAY = new ResourceLocation("evilcraft", "textures/gui/overlay.png");
    private static Broom _instance = null;
    private static final float Y_SPAWN_OFFSET = 1.5f;

    public static Broom getInstance() {
        return _instance;
    }

    public Broom(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 10000, (Fluid)Blood.getInstance());
        this.field_77777_bU = 1;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isPlaceFluids() {
        return false;
    }

    public boolean isPickupFluids() {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_184187_bx() == null && !player.func_70093_af()) {
            player.field_70163_u += 1.5;
            EntityBroom entityBroom = new EntityBroom(world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            entityBroom.setBroomStack(stack);
            entityBroom.field_70177_z = player.field_70177_z;
            world.func_72838_d((Entity)entityBroom);
            player.func_184220_m((Entity)entityBroom);
            stack.func_190918_g(1);
        }
        return MinecraftHelpers.successAction((Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af() && TileHelpers.getCapability((World)world, (BlockPos)blockPos, (EnumFacing)side, (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) == null && world.func_175623_d(blockPos.func_177963_a(0.0, 1.5, 0.0))) {
            EntityBroom entityBroom = new EntityBroom(world, (double)blockPos.func_177958_n() + 0.5, (float)blockPos.func_177956_o() + 1.5f, (double)blockPos.func_177952_p() + 0.5);
            entityBroom.setBroomStack(stack);
            entityBroom.field_70177_z = player.field_70177_z;
            world.func_72838_d((Entity)entityBroom);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        int maxRarity = 0;
        for (IBroomPart part : this.getBroomParts(itemStack)) {
            maxRarity = Math.max(maxRarity, part.getRarity().ordinal());
        }
        return EnumRarity.values()[maxRarity];
    }

    @Override
    public Collection<IBroomPart> getBroomParts(ItemStack itemStack) {
        return BroomParts.REGISTRY.getBroomParts(itemStack);
    }

    @Override
    public Map<BroomModifier, Float> getBroomModifiers(ItemStack itemStack) {
        return BroomModifiers.REGISTRY.getModifiers(itemStack);
    }

    @Override
    public boolean canConsumeBroomEnergy(int amount, ItemStack itemStack, @Nullable EntityLivingBase entityLiving) {
        return this.canConsume(amount, itemStack, entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null);
    }

    @Override
    public int consumeBroom(int amount, ItemStack itemStack, @Nullable EntityLivingBase entityLiving) {
        return FluidHelpers.getAmount((FluidStack)this.consume(amount, itemStack, entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        if (MinecraftHelpers.isShifted()) {
            list.add(TextFormatting.ITALIC + L10NHelpers.localize((String)"broom.parts.evilcraft.types.name", (Object[])new Object[0]));
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(itemStack);
            Map<BroomModifier, Float> modifiers = this.getBroomModifiers(itemStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(baseModifiers.keySet());
            modifierTypes.addAll(modifiers.keySet());
            for (IBroomPart part : this.getBroomParts(itemStack)) {
                String line = part.getTooltipLine("  ");
                if (line == null) continue;
                list.add(line);
            }
            Pair<Integer, Integer> modifiersAndMax = this.getModifiersAndMax(modifiers, baseModifiers);
            int modifierCount = (Integer)modifiersAndMax.getLeft();
            int maxModifiers = (Integer)modifiersAndMax.getRight();
            list.add(TextFormatting.ITALIC + L10NHelpers.localize((String)"broom.modifiers.evilcraft.types.nameparam", (Object[])new Object[]{modifierCount, maxModifiers}));
            for (BroomModifier modifier : modifierTypes) {
                if (!modifier.showTooltip()) continue;
                Float value = modifiers.get(modifier);
                Float baseValue = baseModifiers.get(modifier);
                list.add(modifier.getTooltipLine("  ", value == null ? 0.0f : value.floatValue(), baseValue == null ? 0.0f : baseValue.floatValue()));
            }
        } else {
            list.add(TextFormatting.ITALIC + L10NHelpers.localize((String)"broom.evilcraft.shiftinfo", (Object[])new Object[0]));
        }
    }

    private Pair<Integer, Integer> getModifiersAndMax(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = BroomModifier.getTier(entry.getKey(), entry.getValue().floatValue());
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        return Pair.of((Object)modifiers, (Object)maxModifiers);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFovEvent(FOVUpdateEvent event) {
        if (event.getEntity().func_184187_bx() instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)event.getEntity().func_184187_bx();
            double speed = broom.getLastPlayerSpeed();
            event.setNewfov((float)((double)event.getFov() + speed / 10.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderOverlayEvent(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() instanceof EntityBroom && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            EntityBroom broom = (EntityBroom)player.func_184187_bx();
            ItemStack broomStack = broom.getBroomStack();
            ScaledResolution resolution = event.getResolution();
            int height = 21;
            int width = 21;
            RenderOverlayEventHook.OverlayPosition overlayPosition = RenderOverlayEventHook.OverlayPosition.values()[MathHelper.func_76125_a((int)BroomConfig.guiOverlayPosition, (int)0, (int)(RenderOverlayEventHook.OverlayPosition.values().length - 1))];
            int x = overlayPosition.getX(resolution, width, height) + BroomConfig.guiOverlayPositionOffsetX;
            int y = overlayPosition.getY(resolution, width, height) + BroomConfig.guiOverlayPositionOffsetY;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderHelpers.bindTexture((ResourceLocation)OVERLAY);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(x, y, 11, 0, 24, 24);
            GlStateManager.func_179145_e();
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(broomStack, x + 3, y + 3);
            Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71456_v.func_175179_f(), broomStack, x + 3, y + 3, "");
            RenderHelper.func_74519_b();
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }
}

