/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.LootHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.fluid.Blood;

public class CondensedBloodConfig
extends ItemConfig {
    public static CondensedBloodConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="If this item should be injected in loot tables..", requiresMcRestart=true)
    public static boolean injectLootTables;

    public CondensedBloodConfig() {
        super((ModBase)EvilCraft._instance, true, "condensed_blood", null, null);
    }

    protected IConfigurable initSubInstance() {
        return new ConfigurableItem((ExtendedConfig)this){

            public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                return new FluidWrapper(stack);
            }
        };
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        if (injectLootTables) {
            LootHelpers.injectLootTable((ResourceLocation)new ResourceLocation("evilcraft", "inject/chests/condensed_blood"), (ResourceLocation[])new ResourceLocation[]{LootTableList.field_186420_b, LootTableList.field_186423_e, LootTableList.field_186425_g, LootTableList.field_186422_d, LootTableList.field_186424_f, LootTableList.field_186430_l});
        }
    }

    static {
        injectLootTables = true;
    }

    public static class FluidWrapper
    extends FluidBucketWrapper {
        public FluidWrapper(ItemStack container) {
            super(container);
        }

        protected int getVolume() {
            return 500;
        }

        @Nullable
        public FluidStack getFluid() {
            return new FluidStack((Fluid)Blood.getInstance(), this.getVolume());
        }

        protected void setFluid(Fluid fluid) {
            if (fluid == null) {
                this.container = this.container.func_77946_l();
                this.container.func_190918_g(1);
            }
        }

        protected void setFluid(@Nullable FluidStack fluidStack) {
            if (fluidStack == null) {
                this.container = this.container.func_77946_l();
                this.container.func_190918_g(1);
            }
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount < this.getVolume()) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
                if (doDrain) {
                    this.setFluid((FluidStack)null);
                }
                return fluidStack;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain < this.getVolume()) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null) {
                if (doDrain) {
                    this.setFluid((FluidStack)null);
                }
                return fluidStack;
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), this.getVolume())};
        }
    }
}

