/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.VengeanceSpiritData;

public class TileBoxOfEternalClosure
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final String NBTKEY_SPIRIT = "spiritTag";
    public static final String NBTKEY_PLAYERID = "playerId";
    public static final String NBTKEY_PLAYERNAME = "playerName";
    public static final float START_LID_ANGLE = 65.0f;
    private static final int TICK_MODULUS = 10;
    private static final int TARGET_RADIUS = 10;
    private static final double ABSORB_RADIUS = 0.5;
    private static final int NO_TARGET = -1;
    private static final float LID_STEP = 11.5f;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    public int innerRotation;
    @NBTPersist
    private NBTTagCompound spiritTag = new NBTTagCompound();
    @NBTPersist
    private String playerId = "";
    @NBTPersist
    private String playerName = "";
    private VengeanceSpiritData spiritData = null;
    private VengeanceSpirit targetSpirit = null;
    @NBTPersist(useDefaultValue=false)
    private Integer targetSpiritId = -1;
    @NBTPersist(useDefaultValue=false)
    private Float lidAngle = Float.valueOf(65.0f);
    private float previousLidAngle = 65.0f;
    private State state = State.UNKNOWN;

    public TileBoxOfEternalClosure() {
        this.innerRotation = new Random().nextInt(100000);
    }

    public static ResourceLocation getSpiritNameOrNullFromNBTTag(NBTTagCompound tag) {
        if (tag != null) {
            NBTTagCompound spiritTag = tag.func_74775_l(NBTKEY_SPIRIT);
            return VengeanceSpiritData.getSpiritNameOrNullFromNBTTag(spiritTag);
        }
        return null;
    }

    protected NBTTagCompound getSpiritTag() {
        if (this.spiritTag == null) {
            this.spiritTag = new NBTTagCompound();
        }
        return this.spiritTag;
    }

    public boolean isClosed() {
        return this.getState() == State.CLOSED;
    }

    public State getState() {
        if (this.state == State.UNKNOWN) {
            this.updateState();
        }
        return this.state;
    }

    private void setState(State newState) {
        if (newState != this.state) {
            State oldState = this.state;
            this.state = newState;
            this.onStateChanged(oldState, this.state);
        }
    }

    private void updateState() {
        if (this.lidAngle.floatValue() <= 0.0f) {
            this.setState(State.CLOSED);
        } else if (this.lidAngle.floatValue() >= 65.0f) {
            this.setState(State.OPEN);
        }
    }

    private void onStateChanged(State oldState, State newState) {
        if (oldState == State.UNKNOWN) {
            return;
        }
        switch (this.state) {
            case OPEN: {
                this.onBoxOpened();
                break;
            }
            case CLOSED: {
                this.onBoxClosed();
                break;
            }
            case OPENING: {
                this.onBoxOpening();
                break;
            }
            case CLOSING: {
                this.onBoxClosing();
                break;
            }
        }
    }

    private void onBoxOpened() {
        if (!this.field_145850_b.field_72995_K && this.hasSpirit()) {
            this.releaseSpirit();
        }
    }

    private void onBoxClosed() {
    }

    private void onBoxOpening() {
        if (this.field_145850_b.field_72995_K) {
            this.playOpenSound();
        }
    }

    private void onBoxClosing() {
        if (this.field_145850_b.field_72995_K) {
            this.playCloseSound();
        }
    }

    public boolean hasSpirit() {
        return !this.getSpiritTag().func_82582_d();
    }

    private void releaseSpirit() {
        VengeanceSpirit spirit = this.createNewVengeanceSpirit();
        this.field_145850_b.func_72838_d((Entity)spirit);
        this.clearSpirit();
    }

    private void playOpenSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, pitch);
    }

    private void playCloseSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, pitch);
    }

    private VengeanceSpirit createNewVengeanceSpirit() {
        Random rand = this.field_145850_b.field_73012_v;
        VengeanceSpirit spirit = VengeanceSpirit.fromNBT(this.func_145831_w(), this.getSpiritTag());
        spirit.func_70107_b((double)this.func_174877_v().func_177958_n() + rand.nextDouble(), (double)this.func_174877_v().func_177956_o() + rand.nextDouble(), (double)this.func_174877_v().func_177952_p() + rand.nextDouble());
        spirit.setFrozenDuration(0);
        spirit.setGlobalVengeance(true);
        spirit.setRemainingLife(MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)250, (int)1000));
        return spirit;
    }

    private void clearSpirit() {
        this.spiritTag = new NBTTagCompound();
        this.spiritData = null;
    }

    private float randomFloat(float min, float max) {
        return min + this.field_145850_b.field_73012_v.nextFloat() * max;
    }

    private void playSound(SoundEvent sound, SoundCategory category, float volume, float pitch) {
        this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), sound, category, volume, pitch, false);
    }

    public void open() {
        this.setState(State.OPENING);
    }

    public void close() {
        this.setState(State.CLOSING);
    }

    private void initializeState() {
        if (this.hasSpirit()) {
            this.setState(State.CLOSED);
        } else {
            this.setState(State.OPEN);
        }
    }

    private void initializeLidAngle() {
        if (this.getState() == State.OPEN) {
            this.lidAngle = Float.valueOf(65.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        } else if (this.getState() == State.CLOSED) {
            this.lidAngle = Float.valueOf(0.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        }
    }

    private void setSpirit(VengeanceSpirit spirit) {
        spirit.getData().writeNBT(this.getSpiritTag());
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        ++this.innerRotation;
        if (!this.field_145850_b.field_72995_K) {
            this.updateTileEntityServer();
        } else {
            this.updateTileEntityClient();
        }
        this.updateLidAngle();
    }

    private void updateLidAngle() {
        State state = this.getState();
        this.previousLidAngle = this.lidAngle.floatValue();
        if (state == State.OPENING) {
            this.incrementLidAngle(11.5f);
        } else if (state == State.CLOSING) {
            this.incrementLidAngle(-11.5f);
        }
        if (state == State.OPENING || state == State.CLOSING) {
            this.updateState();
        }
    }

    private void updateTileEntityServer() {
        if (!this.hasSpirit() && this.findsOrHasTargetEntity()) {
            this.pullEntity();
        }
    }

    private void pullEntity() {
        VengeanceSpirit target = this.getTargetSpirit();
        if (target != null) {
            double dx = this.targetSpirit.field_70165_t - (double)this.func_174877_v().func_177958_n() - 0.5;
            double dy = this.targetSpirit.field_70163_u - (double)this.func_174877_v().func_177956_o() - 0.5;
            double dz = this.targetSpirit.field_70161_v - (double)this.func_174877_v().func_177952_p() - 0.5;
            double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            if (target.field_70128_L || !target.isFrozen()) {
                this.setTargetSpirit(null);
            } else {
                BlockPos blockPos = this.func_174877_v();
                AxisAlignedBB boxBoundingBox = this.getBlock().func_185496_a(this.field_145850_b.func_180495_p(blockPos), (IBlockAccess)this.field_145850_b, blockPos).func_186670_a(blockPos);
                AxisAlignedBB spiritBoundingBox = target.func_174813_aQ().func_186662_g(0.5);
                boolean spiritTrapped = spiritBoundingBox.func_72326_a(boxBoundingBox);
                if (spiritTrapped) {
                    this.captureSpirit(this.targetSpirit);
                    this.close();
                } else {
                    double strength = 1.0 / distance / 50.0 + 0.01;
                    target.field_70159_w -= dx * strength;
                    target.field_70181_x -= dy * strength;
                    target.field_70179_y -= dz * strength;
                }
            }
        }
    }

    private void captureSpirit(VengeanceSpirit targetSpirit) {
        for (EntityPlayerMP player : targetSpirit.getEntanglingPlayers()) {
            Advancements.BOX_OF_ETERNAL_CLOSURE_CAPTURE.trigger(player, targetSpirit.getInnerEntity());
        }
        this.field_145850_b.func_72900_e((Entity)targetSpirit);
        this.playerId = targetSpirit.getPlayerId();
        this.playerName = targetSpirit.getPlayerName();
        this.setSpirit(targetSpirit);
        this.setTargetSpirit(null);
        this.close();
    }

    private boolean findsOrHasTargetEntity() {
        return this.hasTargetSpirit() || this.findsTargetEntity();
    }

    private boolean findsTargetEntity() {
        return WorldHelpers.efficientTick((World)this.func_145831_w(), (int)10, (BlockPos)this.func_174877_v()) && this.findNextEntity();
    }

    private void updateTileEntityClient() {
        if (this.hasTargetSpirit()) {
            this.playBeamSound();
        }
    }

    private boolean hasTargetSpirit() {
        return this.getTargetSpirit() != null;
    }

    private void playBeamSound() {
        float volume = this.randomFloat(0.1f, 0.9f);
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(EvilCraftSoundEvents.effect_box_beam, SoundCategory.AMBIENT, volume, pitch);
    }

    private boolean findNextEntity() {
        AxisAlignedBB box = new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()).func_72314_b(10.0, 10.0, 10.0);
        List entities = this.field_145850_b.func_72872_a(VengeanceSpirit.class, box);
        double minDistance = 11.0;
        VengeanceSpirit closest = null;
        for (VengeanceSpirit spirit : entities) {
            double distance;
            if (!spirit.isFrozen() || spirit.isSwarm() || !((distance = spirit.func_70011_f(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p())) < minDistance)) continue;
            minDistance = distance;
            closest = spirit;
        }
        this.setTargetSpirit(closest);
        return this.targetSpirit != null;
    }

    protected void updateLight() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 3);
    }

    public float getLidAngle() {
        return this.lidAngle.floatValue();
    }

    private void setLidAngle(float newLidAngle) {
        if (newLidAngle != this.lidAngle.floatValue()) {
            this.lidAngle = Float.valueOf(newLidAngle);
            if (this.lidAngle.floatValue() < 0.0f) {
                this.lidAngle = Float.valueOf(0.0f);
                this.updateLight();
            } else if (this.lidAngle.floatValue() > 65.0f) {
                this.lidAngle = Float.valueOf(65.0f);
                this.updateLight();
            }
        }
    }

    private void incrementLidAngle(float increment) {
        this.setLidAngle(this.lidAngle.floatValue() + increment);
    }

    public float getPreviousLidAngle() {
        return this.previousLidAngle;
    }

    public VengeanceSpirit getTargetSpirit() {
        if (this.func_145831_w().field_72995_K && this.targetSpiritId == -1) {
            this.targetSpirit = null;
        } else if (this.targetSpirit == null && this.targetSpiritId != -1) {
            this.setTargetSpirit((VengeanceSpirit)this.func_145831_w().func_73045_a(this.targetSpiritId.intValue()));
        }
        return this.targetSpirit;
    }

    private void setTargetSpirit(VengeanceSpirit targetSpirit) {
        VengeanceSpirit old = this.targetSpirit;
        this.targetSpirit = targetSpirit;
        this.targetSpiritId = targetSpirit != null ? Integer.valueOf(targetSpirit.func_145782_y()) : Integer.valueOf(-1);
        if (old != targetSpirit) {
            this.sendUpdate();
        }
    }

    public VengeanceSpiritData getSpiritData() {
        return this.hasSpirit() ? this.loadSpiritDataLazy() : null;
    }

    private VengeanceSpiritData loadSpiritDataLazy() {
        if (this.spiritData == null) {
            this.spiritData = VengeanceSpiritData.fromNBT(this.getSpiritTag());
        }
        return this.spiritData;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    protected void onSendUpdate() {
        super.onSendUpdate();
        this.field_145850_b.func_175685_c(this.func_174877_v(), (Block)this.getBlock(), true);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.initializeState();
        this.initializeLidAngle();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    public static enum State {
        UNKNOWN,
        OPEN,
        OPENING,
        CLOSING,
        CLOSED;

    }
}

