/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.purifier;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.tileentity.TilePurifier;

public class DisenchantPurifyAction
implements IPurifierAction {
    public static final Wrapper<Item> ALLOWED_BOOK = new Wrapper();
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77973_b() == ALLOWED_BOOK.get();
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        if (tile.getBucketsFloored() == tile.getMaxBuckets() && !tile.getPurifyItem().func_190926_b() && !tile.getAdditionalItem().func_190926_b() && tile.getAdditionalItem().func_77973_b() == ALLOWED_BOOK.get()) {
            return !EnchantmentHelper.func_82781_a((ItemStack)tile.getPurifyItem()).isEmpty();
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem().func_77946_l();
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)purifyItem);
        if (!enchantments.isEmpty()) {
            if (tick >= 60) {
                if (!world.field_72995_K) {
                    Enchantment enchantment = this.getRandomEnchantment(world, enchantments);
                    this.setResultingEnchantmentBook(tile, enchantments, enchantment);
                    this.removePriorWorkPenalty(enchantments, purifyItem);
                    purifyItem = this.setRemainingEnchantmentsOnPurifiedItem(enchantments, enchantment, purifyItem);
                    tile.setPurifyItem(purifyItem);
                }
                tile.setBuckets(0, tile.getBucketsRest());
                done = true;
            }
            if (world.field_72995_K) {
                tile.showEffect();
                tile.showEnchantingEffect();
            }
        }
        return done;
    }

    private Enchantment getRandomEnchantment(World world, Map<Enchantment, Integer> enchantments) {
        int enchantmentIndex = world.field_73012_v.nextInt(enchantments.size());
        return (Enchantment)Lists.newArrayList(enchantments.keySet()).get(enchantmentIndex);
    }

    private void setResultingEnchantmentBook(TilePurifier tile, Map<Enchantment, Integer> enchantments, Enchantment enchantment) {
        tile.setAdditionalItem(ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, enchantments.get(enchantment).intValue())));
    }

    private void removePriorWorkPenalty(Map<Enchantment, Integer> enchantments, ItemStack purifyItem) {
        int penalty = purifyItem.func_82838_A();
        int remainingPenalty = penalty - penalty / enchantments.size();
        purifyItem.func_82841_c(remainingPenalty);
    }

    private ItemStack setRemainingEnchantmentsOnPurifiedItem(Map<Enchantment, Integer> enchantments, Enchantment enchantment, ItemStack purifyItem) {
        HashMap remainingEnchantments = Maps.newHashMap(enchantments);
        remainingEnchantments.remove(enchantment);
        if (remainingEnchantments.isEmpty() && purifyItem.func_77973_b() == Items.field_151134_bR) {
            purifyItem = new ItemStack(Items.field_151122_aG);
        }
        if (purifyItem.func_77942_o() && purifyItem.func_77978_p().func_74764_b("StoredEnchantments")) {
            purifyItem.func_77978_p().func_82580_o("StoredEnchantments");
        }
        EnchantmentHelper.func_82782_a((Map)remainingEnchantments, (ItemStack)purifyItem);
        return purifyItem;
    }
}

