/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.bloodmagic;

import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraftcompat.modcompat.bloodmagic.BoundBloodDropConfig;
import org.cyclops.evilcraftcompat.modcompat.bloodmagic.ClientSoulNetworkHandler;

public class BoundBloodDrop
extends ConfigurableDamageIndicatedItemFluidContainer
implements IBindable {
    private static BoundBloodDrop _instance = null;

    public static BoundBloodDrop getInstance() {
        return _instance;
    }

    public BoundBloodDrop(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 1000, (Fluid)Blood.getInstance());
        this.setPlaceFluids(true);
    }

    public boolean onBind(EntityPlayer player, ItemStack stack) {
        return true;
    }

    private static int getCurrentEssence(UUID uuid) {
        return ClientSoulNetworkHandler.getInstance().getCurrentEssence(uuid);
    }

    private static int getMaxEssence(UUID uuid) {
        return Math.max(BoundBloodDrop.getCurrentEssence(uuid), ClientSoulNetworkHandler.getInstance().getMaxEssence(uuid));
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
        if (ItemStackHelpers.isValidCreativeTab((Item)this, (CreativeTabs)tab)) {
            itemList.add((Object)new ItemStack((Item)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.auto_supply"));
        Binding binding = this.getBinding(itemStack);
        if (binding != null) {
            String owner = binding.getOwnerName();
            if (owner == null || owner.isEmpty()) {
                owner = TextFormatting.ITALIC + L10NHelpers.localize((String)(this.func_77658_a() + ".info.current_owner.none"), (Object[])new Object[0]);
            }
            list.add(L10NHelpers.localize((String)(this.func_77658_a() + ".info.current_owner"), (Object[])new Object[]{owner}));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemHelpers.toggleActivation(itemStack);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill(FluidUtil.getFluidHandler((ItemStack)itemStack), world, entity, BoundBloodDropConfig.autoFillBuckets);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandler(stack, 1000);
    }

    public static class FluidHandler
    extends FluidContainerItemWrapperWithSimulation {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity, (Fluid)Blood.getInstance());
        }

        @Nullable
        protected UUID getUuid() {
            Binding binding = this.getBinding();
            if (binding == null) {
                return null;
            }
            return binding.getOwnerId();
        }

        public int getCapacity() {
            UUID uuid = this.getUuid();
            if (uuid == null) {
                return 0;
            }
            if (MinecraftHelpers.isClientSide()) {
                return BoundBloodDrop.getMaxEssence(uuid);
            }
            return NetworkHelper.getMaximumForTier((int)NetworkHelper.getSoulNetwork((UUID)uuid).getOrbTier());
        }

        @Nullable
        protected Binding getBinding() {
            return BoundBloodDrop.getInstance().getBinding(this.getContainer());
        }

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            doFill = this.shouldDoFill(resource, doFill);
            UUID uuid = this.getUuid();
            if (uuid == null) {
                return 0;
            }
            int essence = BoundBloodDrop.getCurrentEssence(uuid);
            FluidStack essenceFluid = BloodFluidConverter.getInstance().convertReverse(BlockLifeEssence.getLifeEssence(), resource);
            int maxFill = Math.max(0, this.getCapacity() - essence);
            int filled = Math.min(maxFill, essenceFluid == null ? 0 : essenceFluid.amount);
            if (doFill && !MinecraftHelpers.isClientSide()) {
                NetworkHelper.getSoulNetwork((UUID)uuid).setCurrentEssence(essence + filled);
            }
            return FluidHelpers.getAmount((FluidStack)BloodFluidConverter.getInstance().convert(new FluidStack(BlockLifeEssence.getLifeEssence(), filled)));
        }

        @Override
        public FluidStack drain(int maxDrain, boolean doDrain) {
            UUID uuid = this.getUuid();
            if (uuid == null) {
                return null;
            }
            int essence = BoundBloodDrop.getCurrentEssence(uuid);
            FluidStack toDrain = new FluidStack((Fluid)Blood.getInstance(), maxDrain);
            FluidStack toDrainEssence = BloodFluidConverter.getInstance().convertReverse(BlockLifeEssence.getLifeEssence(), toDrain);
            int drainEssence = Math.min(essence, toDrainEssence == null ? 0 : toDrainEssence.amount);
            if (doDrain && !MinecraftHelpers.isClientSide()) {
                NetworkHelper.getSoulNetwork((UUID)uuid).setCurrentEssence(essence - drainEssence);
            }
            FluidStack drainedEssence = new FluidStack(BlockLifeEssence.getLifeEssence(), drainEssence);
            return this.wrapSimulatedDrained(BloodFluidConverter.getInstance().convert(drainedEssence), doDrain);
        }

        @Override
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            doDrain = this.shouldDoDrain(resource, doDrain);
            if (resource != null && this.canDrainFluidType(resource)) {
                return this.drain(resource.amount, doDrain);
            }
            return null;
        }
    }
}

