/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.UnlistedProperty;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.evilcraft.block.BloodStainedBlockConfig;
import org.cyclops.evilcraft.client.particle.EntityBloodSplashFX;
import org.cyclops.evilcraft.client.render.model.ModelBloodStainedBlock;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableBlockWithInnerBlocksExtended;
import org.cyclops.evilcraft.tileentity.TileBloodStainedBlock;

public class BloodStainedBlock
extends ConfigurableBlockWithInnerBlocksExtended {
    @BlockProperty
    public static final IUnlistedProperty<IBlockState> INNERBLOCK = new UnlistedProperty("innerblock", IBlockState.class);
    @BlockProperty
    public static final IUnlistedProperty<BlockPos> POS = new UnlistedProperty("pos", BlockPos.class);
    @Icon(location="blocks/bloodStainedBlock_0")
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite icon0;
    @Icon(location="blocks/bloodStainedBlock_1")
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite icon1;
    @Icon(location="blocks/bloodStainedBlock_2")
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite icon2;
    private static BloodStainedBlock _instance = null;

    public static BloodStainedBlock getInstance() {
        return _instance;
    }

    public BloodStainedBlock(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151571_B, TileBloodStainedBlock.class);
        this.func_149711_c(0.5f);
        if (MinecraftHelpers.isClientSide()) {
            eConfig.getMod().getIconProvider().registerIconHolderObject((Object)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180649_a(World par1World, BlockPos blockPos, EntityPlayer par5EntityPlayer) {
        BloodStainedBlock.splash(par1World, blockPos);
        super.func_180649_a(par1World, blockPos, par5EntityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180634_a(World world, BlockPos blockPos, IBlockState blockState, Entity entity) {
        BloodStainedBlock.splash(world, blockPos);
        super.func_180634_a(world, blockPos, blockState, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public static void splash(World world, BlockPos blockPos) {
        if (MinecraftHelpers.isClientSide()) {
            EntityBloodSplashFX.spawnParticles(world, blockPos.func_177982_a(0, 1, 0), 0, 1 + world.field_73012_v.nextInt(3));
        }
    }

    public void func_176224_k(World world, BlockPos blockPos) {
        this.unwrapInnerBlock(world, blockPos);
    }

    public void stainBlock(World world, BlockPos blockPos, int amount) {
        if (world.func_180495_p(blockPos).func_177230_c() != this) {
            this.setInnerBlock(world, blockPos);
        }
        TileBloodStainedBlock tile = (TileBloodStainedBlock)world.func_175625_s(blockPos);
        tile.addAmount(amount);
    }

    public UnstainResult unstainBlock(World world, BlockPos blockPos, int amount) {
        UnstainResult result = new UnstainResult();
        if (world.func_180495_p(blockPos).func_177230_c() == this) {
            TileBloodStainedBlock tile = (TileBloodStainedBlock)world.func_175625_s(blockPos);
            int foundAmount = tile.getAmount();
            result.amount = Math.min(amount, foundAmount);
            tile.addAmount(-result.amount);
            if (result.amount > 0) {
                result.block = this.unwrapInnerBlock(world, blockPos);
            }
        }
        return result;
    }

    protected boolean isBlacklisted(Block block) {
        String name = Block.field_149771_c.func_177774_c((Object)block).toString();
        for (String blacklisted : BloodStainedBlockConfig.blockBlacklist) {
            if (!blacklisted.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canSetInnerBlock(Block block, IBlockAccess world, BlockPos blockPos) {
        return super.canSetInnerBlock(block, world, blockPos) && !this.isBlacklisted(block);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        TileBloodStainedBlock tile = (TileBloodStainedBlock)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileBloodStainedBlock.class));
        extendedBlockState = tile != null ? extendedBlockState.withProperty(INNERBLOCK, (Object)tile.getInnerBlockState()) : extendedBlockState.withProperty(INNERBLOCK, (Object)Blocks.field_150348_b.func_176223_P());
        extendedBlockState = extendedBlockState.withProperty(POS, (Object)pos);
        return extendedBlockState;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new ModelBloodStainedBlock();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    public static class UnstainResult {
        public int amount = 0;
        public IBlockState block = null;
    }
}

