/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import org.cyclops.cyclopscore.config.extendedconfig.BlockContainerConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BoxOfEternalClosure;
import org.cyclops.evilcraft.entity.monster.VengeanceSpiritConfig;
import org.cyclops.evilcraft.tileentity.tickaction.spiritfurnace.BoxCookTickAction;

public class BoxOfEternalClosureConfig
extends BlockContainerConfig {
    public static BoxOfEternalClosureConfig _instance;

    public BoxOfEternalClosureConfig() {
        super((ModBase)EvilCraft._instance, true, "boxOfEternalClosure", null, BoxOfEternalClosure.class);
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockNBT.class;
    }

    public void onRegistered() {
        if (MinecraftHelpers.isClientSide()) {
            // empty if block
        }
        ItemStack spiritStack = new ItemStack(Item.func_150898_a((Block)BoxOfEternalClosure.getInstance()), 1, 0);
        ItemStack swarmStack = spiritStack.func_77946_l();
        BoxOfEternalClosure.setVengeanceSwarmContent(swarmStack);
        for (String chestCategory : MinecraftHelpers.CHESTGENCATEGORIES) {
            for (UUID playerId : BoxCookTickAction.PLAYERDROP_OVERRIDES.keySet()) {
                ItemStack playerStack = spiritStack.func_77946_l();
                BoxOfEternalClosure.setPlayerContent(playerStack, playerId);
                ChestGenHooks.getInfo((String)chestCategory).addItem(new WeightedRandomChestContent(playerStack, 1, 1, 1));
            }
            ChestGenHooks.getInfo((String)chestCategory).addItem(new WeightedRandomChestContent(swarmStack, 1, 1, 3));
        }
    }

    public boolean isHardDisabled() {
        return !Configs.isEnabled(VengeanceSpiritConfig.class);
    }
}

