/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.Achievements;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.DarkOreConfig;
import org.cyclops.evilcraft.item.DarkGem;
import org.cyclops.evilcraft.item.DarkGemConfig;
import org.cyclops.evilcraft.item.DarkGemCrushedConfig;

public class DarkOre
extends ConfigurableBlock
implements IInformationProvider {
    private static DarkOre _instance = null;
    private static final int MINIMUM_DROPS = 1;
    private static final int INCREASE_DROPS = 3;
    private static final int INCREASE_XP = 5;
    private static final int CRUSHEDCHANCE = 4;
    @BlockProperty(ignore=true)
    public static final PropertyBool GLOWING = PropertyBool.func_177716_a((String)"glowing");

    public static DarkOre getInstance() {
        return _instance;
    }

    public DarkOre(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(3.0f);
        this.func_149672_a(field_149769_e);
        this.setHarvestLevel("pickaxe", 2);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    public Item func_180660_a(IBlockState blockState, Random random, int zero) {
        if (Configs.isEnabled(DarkGemConfig.class)) {
            return DarkGem.getInstance();
        }
        return null;
    }

    public int func_149679_a(int amount, Random random) {
        return this.func_149745_a(random) + random.nextInt(amount / 4 + 1);
    }

    public int func_149745_a(Random random) {
        return 1 + random.nextInt(3);
    }

    public void func_180653_a(World world, BlockPos blockPos, IBlockState blockState, float dropchance, int fortune) {
        super.func_180653_a(world, blockPos, blockState, dropchance, fortune);
        if (this.func_180660_a(blockState, world.field_73012_v, fortune) != Item.func_150898_a((Block)this)) {
            int xp = 1 + world.field_73012_v.nextInt(5);
            this.func_180637_b(world, blockPos, xp);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos blockPos, IBlockState blockState, int fortune) {
        List drops = super.getDrops(world, blockPos, blockState, fortune);
        Random rand = new Random();
        if ((fortune > 0 || rand.nextInt(4) == 0) && Configs.isEnabled(DarkGemCrushedConfig.class)) {
            drops.add(new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), rand.nextInt(fortune / 3 + 1) + 1));
        }
        return drops;
    }

    protected ItemStack func_180643_i(IBlockState blockState) {
        return new ItemStack((Block)_instance);
    }

    public int func_149738_a(World world) {
        return 30;
    }

    public void func_176208_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player) {
        player.func_71064_a((StatBase)Achievements.FIRST_AGE, 1);
    }

    public void func_180649_a(World world, BlockPos blockPos, EntityPlayer player) {
        this.glow(world, blockPos);
        super.func_180649_a(world, blockPos, player);
    }

    public void func_180634_a(World world, BlockPos blockPos, IBlockState blockState, Entity entity) {
        if (world.field_72995_K && !(entity instanceof EntityFX)) {
            this.glow(world, blockPos);
        }
        super.func_180634_a(world, blockPos, blockState, entity);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumFacing side, float motionX, float motionY, float motionZ) {
        this.glow(world, blockPos);
        return super.func_180639_a(world, blockPos, blockState, player, side, motionX, motionY, motionZ);
    }

    private boolean isGlowing(World world, BlockPos blockPos) {
        return (Boolean)BlockHelpers.getSafeBlockStateProperty((IBlockState)world.func_180495_p(blockPos), (IProperty)GLOWING, (Object)false);
    }

    private void glow(World world, BlockPos blockPos) {
        if (!world.field_72995_K) {
            return;
        }
        this.sparkle(world, blockPos);
        if (!this.isGlowing(world, blockPos)) {
            world.func_180501_a(blockPos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)GLOWING, (Comparable)Boolean.valueOf(true)), 2);
            world.func_175684_a(blockPos, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_180650_b(World world, BlockPos blockPos, IBlockState state, Random random) {
        if (this.isGlowing(world, blockPos)) {
            world.func_180501_a(blockPos, this.func_176223_P(), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos blockPos, IBlockState state, Random random) {
        if (this.isGlowing(world, blockPos)) {
            this.sparkle(world, blockPos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void sparkle(World world, BlockPos blockPos) {
        if (!world.field_72995_K) {
            return;
        }
        Random random = world.field_73012_v;
        double offset = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double sparkX = (float)blockPos.func_177958_n() + random.nextFloat();
            double sparkY = (float)blockPos.func_177956_o() + random.nextFloat();
            double sparkZ = (float)blockPos.func_177952_p() + random.nextFloat();
            if (l == 0 && !world.func_180495_p(blockPos.func_177982_a(0, 1, 0)).func_177230_c().func_149721_r()) {
                sparkY = (double)(blockPos.func_177956_o() + 1) + offset;
            }
            if (l == 1 && !world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_177230_c().func_149721_r()) {
                sparkY = (double)blockPos.func_177956_o() - offset;
            }
            if (l == 2 && !world.func_180495_p(blockPos.func_177982_a(0, 0, 1)).func_177230_c().func_149721_r()) {
                sparkZ = (double)(blockPos.func_177952_p() + 1) + offset;
            }
            if (l == 3 && !world.func_180495_p(blockPos.func_177982_a(0, 0, -1)).func_177230_c().func_149721_r()) {
                sparkZ = (double)blockPos.func_177952_p() - offset;
            }
            if (l == 4 && !world.func_180495_p(blockPos.func_177982_a(1, 0, 0)).func_177230_c().func_149721_r()) {
                sparkX = (double)(blockPos.func_177958_n() + 1) + offset;
            }
            if (l == 5 && !world.func_180495_p(blockPos.func_177982_a(-1, 0, 0)).func_177230_c().func_149721_r()) {
                sparkX = (double)blockPos.func_177958_n() - offset;
            }
            if (!(sparkX < (double)blockPos.func_177958_n() || sparkX > (double)(blockPos.func_177958_n() + 1) || sparkY < 0.0 || sparkY > (double)(blockPos.func_177956_o() + 1) || sparkZ < (double)blockPos.func_177952_p()) && !(sparkZ > (double)(blockPos.func_177952_p() + 1))) continue;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, sparkX, sparkY, sparkZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public String getInfo(ItemStack itemStack) {
        return IInformationProvider.INFO_PREFIX + L10NHelpers.localize((String)(this.func_149739_a() + ".info.custom"), (Object[])new Object[]{DarkOreConfig.startY, DarkOreConfig.endY});
    }

    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }
}

