/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.evilcraft.block.ColossalBloodChest;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.core.block.CubeDetector;
import org.cyclops.evilcraft.tileentity.TileColossalBloodChest;

public class ReinforcedUndeadPlank
extends ConfigurableBlock
implements CubeDetector.IDetectionListener {
    @BlockProperty
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private static ReinforcedUndeadPlank _instance = null;

    public static ReinforcedUndeadPlank getInstance() {
        return _instance;
    }

    public ReinforcedUndeadPlank(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149672_a(field_149766_f);
        this.setHarvestLevel("axe", 2);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d() {
        return false;
    }

    public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    private void triggerDetector(World world, BlockPos blockPos, boolean valid) {
        TileColossalBloodChest.detector.detect(world, blockPos, valid ? null : blockPos, true);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.captureBlockSnapshots) {
            this.triggerDetector(world, pos, true);
        }
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState blockState) {
        super.func_176213_c(world, blockPos, blockState);
        if (!world.captureBlockSnapshots) {
            this.triggerDetector(world, blockPos, true);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            this.triggerDetector(world, pos, false);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void onDetect(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            boolean change = (Boolean)world.func_180495_p(location).func_177229_b((IProperty)ACTIVE) == false;
            world.func_180501_a(location, world.func_180495_p(location).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(valid)), 2);
            if (change) {
                TileColossalBloodChest.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumFacing side, float posX, float posY, float posZ) {
        if (((Boolean)blockState.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            final Wrapper tileLocationWrapper = new Wrapper();
            TileColossalBloodChest.detector.detect(world, blockPos, null, new CubeDetector.IValidationAction(){

                @Override
                public void onValidate(BlockPos location, Block block) {
                    if (block == ColossalBloodChest.getInstance()) {
                        tileLocationWrapper.set(location);
                    }
                }
            }, false);
            BlockPos tileLocation = (BlockPos)tileLocationWrapper.get();
            if (tileLocation != null) {
                world.func_180495_p(tileLocation).func_177230_c().func_180639_a(world, tileLocation, world.func_180495_p(tileLocation), player, side, posX, posY, posZ);
                return true;
            }
        }
        return super.func_180639_a(world, blockPos, blockState, player, side, posX, posY, posZ);
    }
}

