/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.model.DynamicChildItemModel;
import org.cyclops.evilcraft.block.DarkTank;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.RenderHelpers;

public class ModelDarkTank
extends DynamicChildItemModel {
    private int currentCapacity = 0;
    private FluidStack currentFluidStack = null;

    public ModelDarkTank(IBakedModel baseModel) {
        super(baseModel);
    }

    protected IBlockTank getBlockTank(ItemStack itemStack) {
        return DarkTank.getInstance();
    }

    public IBakedModel handleItemState(ItemStack itemStack) {
        IBlockTank tank = this.getBlockTank(itemStack);
        if (itemStack.func_77978_p() != null) {
            this.currentFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_77978_p().func_74775_l(tank.getTankNBTName()));
            this.currentCapacity = tank.getTankCapacity(itemStack);
        }
        return this;
    }

    public List<BakedQuad> func_177550_a() {
        ArrayList combinedList = Lists.newArrayList();
        if (this.currentFluidStack != null) {
            combinedList.addAll(this.getFluidQuads(this.currentFluidStack, this.currentCapacity));
        }
        combinedList.addAll(this.getBaseModel().func_177550_a());
        return combinedList;
    }

    protected List<BakedQuad> getFluidQuads(FluidStack fluidStack, int capacity) {
        float height = Math.min(1.0f, (float)fluidStack.amount / (float)capacity) / 1.01f;
        ArrayList quads = Lists.newArrayList();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TextureAtlasSprite texture = RenderHelpers.getFluidIcon(fluidStack, side);
            if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                ModelDarkTank.addBakedQuadRotated((List)quads, (float)0.126f, (float)0.874f, (float)0.126f, (float)0.874f, (float)height, (TextureAtlasSprite)texture, (EnumFacing)side, (int)ROTATION_FIX[side.ordinal()]);
                continue;
            }
            float x1 = 0.126f;
            float x2 = 0.874f;
            float z1 = 0.001f;
            float z2 = height;
            if (side == EnumFacing.EAST || side == EnumFacing.SOUTH) {
                z1 = 0.999f - height;
                z2 = 0.999f;
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                float tmp1 = x1;
                float tmp2 = x2;
                x1 = z1;
                x2 = z2;
                z1 = tmp1;
                z2 = tmp2;
            }
            ModelDarkTank.addBakedQuadRotated((List)quads, (float)x1, (float)x2, (float)z1, (float)z2, (float)0.874f, (TextureAtlasSprite)texture, (EnumFacing)side, (int)ROTATION_FIX[side.ordinal()]);
        }
        return quads;
    }
}

