/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.gui.container;

import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.helper.RenderHelpers;

public abstract class GuiContainerTankInventory<T extends TankInventoryTileEntity>
extends GuiContainerExtended {
    private boolean showTank = false;
    private int tankWidth;
    private int tankHeight;
    private int tankX;
    private int tankY;
    private int tankTargetX;
    private int tankTargetY;
    private boolean showProgress = false;
    private int progressWidth;
    private int progressHeight;
    private int progressX;
    private int progressY;
    private int progressTargetX;
    private int progressTargetY;
    protected T tile;

    public GuiContainerTankInventory(ExtendedInventoryContainer container, T tile) {
        super(container);
        this.tile = tile;
    }

    protected void setTank(int tankWidth, int tankHeight, int tankX, int tankY, int tankTargetX, int tankTargetY) {
        this.showTank = true;
        this.tankWidth = tankWidth;
        this.tankHeight = tankHeight;
        this.tankX = tankX;
        this.tankY = tankY;
        this.tankTargetX = tankTargetX + this.offsetX;
        this.tankTargetY = tankTargetY + this.offsetY;
    }

    protected void setProgress(int progressWidth, int progressHeight, int progressX, int progressY, int progressTargetX, int progressTargetY) {
        this.showProgress = true;
        this.progressWidth = progressWidth;
        this.progressHeight = progressHeight;
        this.progressX = progressX;
        this.progressY = progressY;
        this.progressTargetX = progressTargetX + this.offsetX;
        this.progressTargetY = progressTargetY + this.offsetY;
    }

    protected boolean isShowProgress() {
        return this.showProgress;
    }

    protected int getProgressXScaled(int width) {
        return width;
    }

    protected int getProgressYScaled(int height) {
        return height;
    }

    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        if (this.isShowProgress()) {
            this.func_73729_b(this.field_147003_i + this.progressTargetX, this.field_147009_r + this.progressTargetY, this.progressX, this.progressY, this.getProgressXScaled(this.progressWidth), this.getProgressYScaled(this.progressHeight));
        }
    }

    protected void drawForgegroundString() {
        this.field_146289_q.func_78276_b(this.tile.func_70005_c_(), 8 + this.offsetX, 4 + this.offsetY, 0x404040);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawForgegroundString();
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SingleUseTank tank = this.tile.getTank();
        if (this.shouldRenderTank()) {
            int tankSize = Math.min(tank.getCapacity(), tank.getFluidAmount()) * this.tankHeight / tank.getCapacity();
            this.drawTank(this.tankTargetX, this.tankTargetY, tank.getAcceptedFluid(), tankSize);
        }
        this.drawAdditionalForeground(mouseX, mouseY);
        GlStateManager.func_179084_k();
    }

    protected void drawAdditionalForeground(int mouseX, int mouseY) {
    }

    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    protected boolean shouldRenderTank() {
        if (!this.showTank) {
            return false;
        }
        SingleUseTank tank = this.tile.getTank();
        return tank != null && tank.getAcceptedFluid() != null && tank.getFluidAmount() > 0;
    }

    protected void drawTank(int xOffset, int yOffset, Fluid fluid, int level) {
        if (fluid != null) {
            FluidStack stack = new FluidStack(fluid, 1);
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon(stack, EnumFacing.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight = 0;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                this.field_146297_k.field_71446_o.func_110577_a(RenderHelpers.TEXTURE_MAP);
                this.func_175175_a(xOffset, yOffset - textureHeight - verticalOffset, icon, this.tankWidth, textureHeight);
                verticalOffset += 16;
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            this.func_73729_b(xOffset, yOffset - this.tankHeight, this.tankX, this.tankY, this.tankWidth, this.tankHeight);
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        if (this.func_146978_c(this.tankTargetX, this.tankTargetY - this.tankHeight, this.tankWidth, this.tankHeight, mouseX, mouseY) && this.shouldRenderTank()) {
            SingleUseTank tank = this.tile.getTank();
            String fluidName = tank.getFluid().getLocalizedName();
            this.drawBarTooltipTank(fluidName, tank.getFluid(), tank.getFluidAmount(), tank.getCapacity(), mouseX, mouseY);
        }
    }

    protected void drawBarTooltipTank(String name, FluidStack fluidStack, int amount, int capacity, int x, int y) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(name);
        lines.add(DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)capacity));
        this.drawTooltip(lines, x, y);
    }
}

