/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.client.model.BroomModelBaked;

public class BroomModel
implements IModel {
    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(BroomParts.REGISTRY.getPartModels());
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        BroomModelBaked bakedModel = new BroomModelBaked();
        for (IBroomPart part : BroomParts.REGISTRY.getParts()) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)BroomParts.REGISTRY.getPartModel(part));
                IFlexibleBakedModel bakedAspectModel = model.bake(state, format, bakedTextureGetter);
                bakedModel.addBroomModel(part, (IBakedModel)bakedAspectModel);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bakedModel;
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }
}

