/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.config.configurable;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.client.render.model.ModelInnerBlock;

public abstract class ConfigurableBlockWithInnerBlocks
extends ConfigurableBlock
implements IInformationProvider {
    protected final IBlockState[] INNER_BLOCKS = this.makeInnerBlockList();

    public ConfigurableBlockWithInnerBlocks(ExtendedConfig eConfig, Material material) {
        super(eConfig, material);
    }

    protected abstract IBlockState[] makeInnerBlockList();

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int j = 0; j < this.INNER_BLOCKS.length; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    public Item func_180660_a(IBlockState blockState, Random random, int zero) {
        return this.getBlockFromState(blockState).func_177230_c().func_180660_a(this.getBlockFromState(blockState), random, zero);
    }

    protected ItemStack func_180643_i(IBlockState blockState) {
        return new ItemStack(this.getBlockFromState(blockState).func_177230_c());
    }

    public String getInfo(ItemStack itemStack) {
        return L10NHelpers.localize((String)"tile.blocks.evilcraft.innerBlock.info", (Object[])new Object[]{EnumChatFormatting.ITALIC + this.getBlockFromMeta(itemStack.func_77952_i()).func_177230_c().func_149732_F()});
    }

    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    public int getMetadataFromBlock(Block block) {
        for (int i = 0; i < this.INNER_BLOCKS.length; ++i) {
            if (this.INNER_BLOCKS[i].func_177230_c() != block) continue;
            return i;
        }
        return -1;
    }

    protected abstract PropertyInteger getMetaProperty();

    public IBlockState getBlockFromState(IBlockState blockState) {
        if (blockState.func_177230_c() != this) {
            return this.INNER_BLOCKS[0];
        }
        return this.getBlockFromMeta((Integer)blockState.func_177229_b((IProperty)this.getMetaProperty()));
    }

    public IBlockState getBlockFromMeta(int blockMeta) {
        return this.INNER_BLOCKS[Math.min(this.INNER_BLOCKS.length - 1, blockMeta)];
    }

    public int getInnerBlocks() {
        return this.INNER_BLOCKS.length;
    }

    public float func_176195_g(World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        return this.getBlockFromState(blockState).func_177230_c().func_176195_g(world, blockPos);
    }

    public int func_180651_a(IBlockState blockState) {
        return (Integer)blockState.func_177229_b((IProperty)this.getMetaProperty());
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos blockPos, EntityPlayer player) {
        return true;
    }

    public float func_180647_a(EntityPlayer player, World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        return this.getBlockFromState(blockState).func_177230_c().func_180647_a(player, world, blockPos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess world, BlockPos blockPos, int renderPass) {
        return this.getBlockFromState(world.func_180495_p(blockPos)).func_177230_c().func_180662_a(world, blockPos, renderPass);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState blockState) {
        return this.getBlockFromState(blockState).func_177230_c().func_180644_h(blockState);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        BlockPos pos = target.func_178782_a();
        RenderHelpers.addBlockHitEffects((EffectRenderer)effectRenderer, (World)worldObj, (IBlockState)this.getBlockFromState(worldObj.func_180495_p(pos)), (BlockPos)pos, (EnumFacing)target.field_178784_b);
        return true;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new ModelInnerBlock(this);
    }
}

