/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class VirtualTank
implements IFluidTank {
    public static final EnumFacing TARGETSIDE = EnumFacing.UP;
    private final ITankProvider tankProvider;
    private final boolean spreadEvenly;

    public VirtualTank(ITankProvider tankProvider, boolean spreadEvenly) {
        this.tankProvider = tankProvider;
        this.spreadEvenly = spreadEvenly;
    }

    protected IFluidHandler[] getTanks() {
        IFluidHandler[] tanks = this.tankProvider.getVirtualTankChildren();
        if (tanks == null) {
            tanks = new IFluidHandler[]{};
        }
        return tanks;
    }

    public FluidStack getFluid() {
        if (this.isSpreadEvenly()) {
            FluidStack minFluid = null;
            int min = Integer.MAX_VALUE;
            for (IFluidHandler tank : this.getTanks()) {
                for (FluidTankInfo info : tank.getTankInfo(TARGETSIDE)) {
                    FluidStack tankFluid = info.fluid;
                    if (tankFluid == null || tankFluid.amount >= min) continue;
                    min = tankFluid.amount;
                    minFluid = tankFluid;
                }
            }
            return minFluid == null ? null : new FluidStack(minFluid.getFluid(), min * this.getTanks().length);
        }
        FluidStack total = null;
        for (IFluidHandler tank : this.getTanks()) {
            for (FluidTankInfo info : tank.getTankInfo(TARGETSIDE)) {
                FluidStack tankFluid = info.fluid;
                if (tankFluid == null) continue;
                if (total == null) {
                    total = tankFluid.copy();
                    continue;
                }
                if (total.getFluid() != tankFluid.getFluid()) continue;
                total = new FluidStack(total.getFluid(), total.amount + tankFluid.amount);
            }
        }
        return total;
    }

    public int getFluidAmount() {
        FluidStack fluidStack = this.getFluid();
        return fluidStack == null ? 0 : fluidStack.amount;
    }

    public int getCapacity() {
        if (this.isSpreadEvenly()) {
            int min = Integer.MAX_VALUE;
            for (IFluidHandler tank : this.getTanks()) {
                for (FluidTankInfo info : tank.getTankInfo(TARGETSIDE)) {
                    min = Math.min(min, info.capacity);
                }
            }
            return min * this.getTanks().length;
        }
        int total = 0;
        for (IFluidHandler tank : this.getTanks()) {
            for (FluidTankInfo info : tank.getTankInfo(TARGETSIDE)) {
                total += info.capacity;
            }
        }
        return total;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        FluidStack toFill = resource.copy();
        int totalFilled = 0;
        int tanks = this.getTanks().length;
        IFluidHandler[] tanksArray = this.getTanks();
        for (int i = 0; i < tanks; ++i) {
            IFluidHandler tank = tanksArray[i];
            if (this.isSpreadEvenly()) {
                toFill = resource.copy();
                resource.amount = resource.amount / tanks + (i <= resource.amount % tanks ? 1 : 0);
            }
            int filled = tank.fill(TARGETSIDE, toFill, doFill);
            toFill = toFill.copy();
            toFill.amount -= filled;
            if ((totalFilled += filled) != resource.amount) continue;
            return totalFilled;
        }
        return totalFilled;
    }

    protected boolean isSpreadEvenly() {
        return this.spreadEvenly;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int toDrain = maxDrain;
        FluidStack totalDrained = null;
        int tanks = this.getTanks().length;
        IFluidHandler[] tanksArray = this.getTanks();
        for (int i = 0; i < tanks; ++i) {
            IFluidHandler tank;
            FluidStack drained;
            if (this.isSpreadEvenly()) {
                toDrain = maxDrain / tanks + (i <= maxDrain % tanks ? 1 : 0);
            }
            if ((drained = (tank = tanksArray[i]).drain(TARGETSIDE, toDrain, doDrain)) == null) continue;
            toDrain -= drained.amount;
            if (totalDrained == null) {
                totalDrained = drained;
            } else {
                totalDrained.amount += drained.amount;
            }
            if (totalDrained.amount != maxDrain) continue;
            return totalDrained;
        }
        return totalDrained;
    }

    public static interface ITankProvider {
        @Nullable
        public IFluidHandler[] getVirtualTankChildren();
    }
}

