/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderHelpers {
    public static TextureAtlasSprite EMPTYICON;
    public static ResourceLocation TEXTURE_MAP;

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176223_P());
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, EnumFacing side) {
        TextureAtlasSprite icon;
        BlockStaticLiquid defaultBlock;
        BlockStaticLiquid block = defaultBlock = Blocks.field_150355_j;
        if (fluid.getFluid().getBlock() != null) {
            block = fluid.getFluid().getBlock();
        }
        if (side == null) {
            side = EnumFacing.UP;
        }
        if ((icon = fluid.getFluid().getFlowingIcon()) == null || side == EnumFacing.UP || side == EnumFacing.DOWN) {
            icon = fluid.getFluid().getStillIcon();
        }
        if (icon == null && (icon = RenderHelpers.getBlockIcon((Block)block)) == null) {
            icon = RenderHelpers.getBlockIcon((Block)defaultBlock);
        }
        return icon;
    }

    public static void renderFluidContext(FluidStack fluid, double x, double y, double z, IFluidContextRender render) {
        if (fluid != null && fluid.amount > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            render.renderFluid(fluid);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public static void setBrightness(int brightness) {
        Tessellator.func_178181_a().func_178180_c().func_178963_b(brightness);
    }

    public static void renderTileFluidContext(FluidStack fluid, final double x, final double y, final double z, final TileEntity tile, final IFluidContextRender render) {
        RenderHelpers.renderFluidContext(fluid, x, y, z, new IFluidContextRender(){

            @Override
            public void renderFluid(FluidStack fluid) {
                BlockPos pos = new BlockPos(x, y, z);
                Block block = tile.func_145831_w().func_180495_p(pos).func_177230_c();
                RenderHelpers.setBrightness(2 * block.func_176207_c((IBlockAccess)tile.func_145831_w(), pos));
                render.renderFluid(fluid);
            }
        });
    }

    static {
        TEXTURE_MAP = TextureMap.field_110575_b;
    }

    public static interface IFluidContextRender {
        public void renderFluid(FluidStack var1);
    }
}

