/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.entity.monster.WerewolfConfig;
import org.cyclops.evilcraft.entity.villager.WerewolfVillagerConfig;
import org.cyclops.evilcraft.item.WerewolfBoneConfig;
import org.cyclops.evilcraft.item.WerewolfFurConfig;

public class Werewolf
extends EntityMob
implements IConfigurable {
    private NBTTagCompound villagerNBTTagCompound = new NBTTagCompound();
    private boolean fromVillager = false;
    private static final int BARKCHANCE = 1000;
    private static final int BARKLENGTH = 40;
    private static int barkprogress = -1;

    public Werewolf(World world) {
        super(world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.field_70178_ae = false;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false, false));
        this.villagerNBTTagCompound.func_74768_a("Profession", WerewolfVillagerConfig._instance.getId());
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.75f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.625);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    public void func_70014_b(NBTTagCompound NBTTagCompound2) {
        super.func_70014_b(NBTTagCompound2);
        NBTTagCompound2.func_74782_a("villager", (NBTBase)this.villagerNBTTagCompound);
        NBTTagCompound2.func_74757_a("fromVillager", this.fromVillager);
    }

    public void func_70037_a(NBTTagCompound NBTTagCompound2) {
        super.func_70037_a(NBTTagCompound2);
        this.villagerNBTTagCompound = NBTTagCompound2.func_74775_l("villager");
        this.fromVillager = NBTTagCompound2.func_74767_n("fromVillager");
    }

    public static boolean isWerewolfTime(World world) {
        return (double)world.func_130001_d() == 1.0 && !MinecraftHelpers.isDay((World)world) && world.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    private static void replaceEntity(EntityLiving old, EntityLiving neww, World world) {
        neww.func_82149_j((Entity)old);
        world.func_72900_e((Entity)old);
        world.func_72838_d((Entity)neww);
        world.func_180498_a(null, 1016, old.func_180425_c(), 0);
    }

    public void replaceWithVillager() {
        if (Configs.isEnabled(WerewolfVillagerConfig.class)) {
            EntityVillager villager = new EntityVillager(this.field_70170_p, WerewolfVillagerConfig._instance.getId());
            Werewolf.replaceEntity((EntityLiving)this, (EntityLiving)villager, this.field_70170_p);
            villager.func_70037_a(this.villagerNBTTagCompound);
        }
    }

    public static void replaceVillager(EntityVillager villager) {
        if (Configs.isEnabled(WerewolfConfig.class)) {
            Werewolf werewolf = new Werewolf(villager.field_70170_p);
            villager.func_70014_b(werewolf.getVillagerNBTTagCompound());
            werewolf.setFromVillager(true);
            Werewolf.replaceEntity((EntityLiving)villager, (EntityLiving)werewolf, villager.field_70170_p);
        }
    }

    public void func_70636_d() {
        if (!(this.field_70170_p.field_72995_K || Werewolf.isWerewolfTime(this.field_70170_p) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL)) {
            this.replaceWithVillager();
        } else {
            super.func_70636_d();
        }
        Random random = this.field_70170_p.field_73012_v;
        if (random.nextInt(1000) == 0 && barkprogress == -1) {
            ++barkprogress;
        } else if (barkprogress > -1) {
            this.func_85030_a("mob.wolf.growl", 0.15f, 1.0f);
            if (++barkprogress > 40) {
                barkprogress = -1;
            }
        }
    }

    public float getBarkProgressScaled(float scale) {
        if (barkprogress == -1) {
            return 0.0f;
        }
        return (float)barkprogress / 40.0f * scale;
    }

    protected Item func_146068_u() {
        if (Configs.isEnabled(WerewolfBoneConfig.class)) {
            return WerewolfBoneConfig._instance.getItemInstance();
        }
        return super.func_146068_u();
    }

    protected void func_82164_bB() {
        if (Configs.isEnabled(WerewolfFurConfig.class)) {
            this.func_145779_a(WerewolfFurConfig._instance.getItemInstance(), 1);
        }
    }

    protected String func_70639_aQ() {
        return "mob.wolf.growl";
    }

    protected String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wolf.death";
    }

    protected void func_180429_a(BlockPos blockPos, Block block) {
        this.func_85030_a("mob.zombie.step", 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected boolean func_70692_ba() {
        return !this.isFromVillager();
    }

    public NBTTagCompound getVillagerNBTTagCompound() {
        return this.villagerNBTTagCompound;
    }

    public boolean isFromVillager() {
        return this.fromVillager;
    }

    public void setFromVillager(boolean fromVillager) {
        this.fromVillager = fromVillager;
    }

    public ExtendedConfig<?> getConfig() {
        return null;
    }
}

