/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.enchantment.EnchantmentBreaking;
import org.cyclops.evilcraft.enchantment.EnchantmentBreakingConfig;
import org.cyclops.evilcraft.enchantment.EnchantmentLifeStealing;
import org.cyclops.evilcraft.enchantment.EnchantmentLifeStealingConfig;
import org.cyclops.evilcraft.enchantment.EnchantmentPoisonTip;
import org.cyclops.evilcraft.enchantment.EnchantmentPoisonTipConfig;
import org.cyclops.evilcraft.enchantment.EnchantmentUnusing;
import org.cyclops.evilcraft.enchantment.EnchantmentUnusingConfig;

public class LivingAttackEventHook {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingAttack(LivingAttackEvent event) {
        this.stealLife(event);
        this.unusingEvent(event);
        this.breakingEvent(event);
        this.poisonTipEvent(event);
    }

    private void stealLife(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack itemStack;
        int enchantmentListID;
        if (Configs.isEnabled(EnchantmentLifeStealingConfig.class) && event.source.func_76346_g() instanceof EntityPlayer && (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()), (int)EnchantmentLifeStealingConfig._instance.ID)) > -1) {
            float damage = event.ammount;
            int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)itemStack, (int)enchantmentListID);
            EnchantmentLifeStealing.stealLife((EntityLivingBase)player, damage, level);
        }
    }

    private void unusingEvent(LivingAttackEvent event) {
        EntityLivingBase entity;
        ItemStack itemStack;
        if (Configs.isEnabled(EnchantmentUnusingConfig.class) && event.source.func_76346_g() instanceof EntityLivingBase && EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = (entity = (EntityLivingBase)event.source.func_76346_g()).func_71124_b(0)), (int)EnchantmentUnusingConfig._instance.ID) > -1 && EnchantmentUnusing.unuseTool(itemStack)) {
            event.setCanceled(true);
        }
    }

    private void breakingEvent(LivingAttackEvent event) {
        EntityLivingBase entity;
        ItemStack itemStack;
        int enchantmentListID;
        if (Configs.isEnabled(EnchantmentBreakingConfig.class) && event.source.func_76346_g() instanceof EntityLivingBase && (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = (entity = (EntityLivingBase)event.source.func_76346_g()).func_71124_b(0)), (int)EnchantmentBreakingConfig._instance.ID)) > -1) {
            EnchantmentBreaking.amplifyDamage(itemStack, enchantmentListID, new Random());
        }
    }

    private void poisonTipEvent(LivingAttackEvent event) {
        EntityLivingBase entity;
        ItemStack itemStack;
        int enchantmentListID;
        if (Configs.isEnabled(EnchantmentPoisonTipConfig.class) && event.source.func_76346_g() instanceof EntityLivingBase && (enchantmentListID = EnchantmentHelpers.doesEnchantApply((ItemStack)(itemStack = (entity = (EntityLivingBase)event.source.func_76346_g()).func_71124_b(0)), (int)EnchantmentPoisonTipConfig._instance.ID)) > -1) {
            int level = EnchantmentHelpers.getEnchantmentLevel((ItemStack)itemStack, (int)enchantmentListID);
            EnchantmentPoisonTip.poison((EntityLivingBase)event.entity, level);
        }
    }
}

