/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.block.ExcrementPile;
import org.cyclops.evilcraft.block.ExcrementPileConfig;
import org.cyclops.evilcraft.entity.monster.Werewolf;
import org.cyclops.evilcraft.entity.villager.WerewolfVillagerConfig;

public class LivingUpdateEventHook {
    private static final int CHANCE_DROP_EXCREMENT = 500;
    private static final int CHANCE_DIE_WITHOUT_ANY_REASON = 1000000;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (WorldHelpers.efficientTick((World)event.entity.field_70170_p, (int)80, (int[])new int[0])) {
            this.dropExcrement(event);
            this.dieWithoutAnyReason(event);
            this.transformWerewolfVillager(event);
        }
    }

    private void dropExcrement(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityAnimal && Configs.isEnabled(ExcrementPileConfig.class) && !event.entity.field_70170_p.field_72995_K && event.entity.field_70170_p.field_73012_v.nextInt(500) == 0) {
            EntityAnimal entity;
            World world = entity.field_70170_p;
            entity = (EntityAnimal)event.entity;
            BlockPos blockPos = entity.func_180425_c();
            if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_177230_c().func_149721_r()) {
                world.func_175656_a(blockPos, ExcrementPile.getInstance().func_176223_P());
            } else if (world.func_180495_p(blockPos).func_177230_c() == ExcrementPile.getInstance()) {
                ExcrementPile.getInstance().heightenPileAt(world, blockPos);
            }
        }
    }

    private void dieWithoutAnyReason(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer && GeneralConfig.dieWithoutAnyReason && event.entity.field_70170_p.field_73012_v.nextInt(1000000) == 0 && !event.entity.field_70170_p.field_72995_K) {
            EntityPlayer entity = (EntityPlayer)event.entity;
            entity.func_70097_a((DamageSource)ExtendedDamageSource.dieWithoutAnyReason, Float.MAX_VALUE);
        }
    }

    private void transformWerewolfVillager(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityVillager && !event.entity.field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)event.entity;
            if (Werewolf.isWerewolfTime(event.entity.field_70170_p) && Configs.isEnabled(WerewolfVillagerConfig.class) && villager.func_70946_n() == WerewolfVillagerConfig._instance.getId()) {
                Werewolf.replaceVillager(villager);
            }
        }
    }
}

