/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook.pageelement;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.block.SanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.item.BucketBloodConfig;
import org.cyclops.evilcraft.tileentity.TileSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;

public class EnvironmentalAccumulatorRecipeAppendix
extends RecipeAppendix<IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties>> {
    private static final ResourceLocation WEATHERS = new ResourceLocation("evilcraft", "textures/gui/weathers.png");
    private static final Map<WeatherType, Integer> X_ICON_OFFSETS = new HashMap<WeatherType, Integer>();
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int START_X_RESULT = 68;
    private static final int Y_START = 2;
    private static final AdvancedButton.Enum INPUT;
    private static final AdvancedButton.Enum RESULT;

    public EnvironmentalAccumulatorRecipeAppendix(IInfoBook infoBook, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe) {
        super(infoBook, recipe);
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return 42;
    }

    protected String getUnlocalizedTitle() {
        return "tile.blocks.evilcraft.environmentalAccumulator.name";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton());
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton());
        super.bakeElement(infoSection);
    }

    public void drawElementInner(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        boolean sanguinary = this.getTick(gui) % 2 == 1;
        int middle = (width - 16) / 2;
        gui.drawArrowRight(x + middle - 3, y + 23 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStacks(((EnvironmentalAccumulatorRecipeComponent)((IRecipe)this.recipe).getInput()).getItemStacks(), tick);
        ItemStack result = this.prepareItemStacks(((EnvironmentalAccumulatorRecipeComponent)((IRecipe)this.recipe).getOutput()).getItemStacks(), tick);
        this.renderItem(gui, x + 16, y + 23, input, mx, my, INPUT);
        this.renderItem(gui, x + 68, y + 23, result, mx, my, RESULT);
        this.renderItem(gui, x + middle, y + 23, new ItemStack((Block)(sanguinary ? SanguinaryEnvironmentalAccumulator.getInstance() : EnvironmentalAccumulator.getInstance())), mx, my, false, null);
        Integer inputX = X_ICON_OFFSETS.get(((EnvironmentalAccumulatorRecipeComponent)((IRecipe)this.recipe).getInput()).getWeatherType());
        if (inputX != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WEATHERS);
            gui.func_73729_b(x + 16, y + 2, inputX.intValue(), 0, 16, 16);
            gui.drawOuterBorder(x + 16, y + 2, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
            Integer outputX = X_ICON_OFFSETS.get(((EnvironmentalAccumulatorRecipeComponent)((IRecipe)this.recipe).getOutput()).getWeatherType());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WEATHERS);
            gui.func_73729_b(x + 68, y + 2, outputX.intValue(), 0, 16, 16);
            gui.drawOuterBorder(x + 68, y + 2, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (sanguinary) {
            this.renderItem(gui, x + middle, y + 2, new ItemStack(BucketBloodConfig._instance.getItemInstance()), mx, my, false, null);
            FontRenderer fontRenderer = gui.getFontRenderer();
            boolean oldUnicode = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(true);
            fontRenderer.func_78275_b(false);
            int amount = AccumulateItemTickAction.getUsage((EnvironmentalAccumulatorRecipeProperties)((IRecipe)this.recipe).getProperties());
            FluidStack fluidStack = new FluidStack(TileSanguinaryEnvironmentalAccumulator.ACCEPTED_FLUID, amount);
            String line = fluidStack.amount + " mB";
            fontRenderer.func_78279_b(line, x + middle - 5, y + 16, 200, 0);
            fontRenderer.func_78264_a(oldUnicode);
        }
    }

    static {
        X_ICON_OFFSETS.put(WeatherType.CLEAR, 0);
        X_ICON_OFFSETS.put(WeatherType.RAIN, 16);
        X_ICON_OFFSETS.put(WeatherType.LIGHTNING, 32);
        INPUT = AdvancedButton.Enum.create();
        RESULT = AdvancedButton.Enum.create();
    }
}

