/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.ItemFluidContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.block.BloodStainedBlock;
import org.cyclops.evilcraft.block.BloodStainedBlockConfig;
import org.cyclops.evilcraft.client.particle.EntityBloodSplashFX;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableBlockWithInnerBlocksExtended;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.item.BloodExtractorConfig;
import org.cyclops.evilcraft.tileentity.TileBloodStainedBlock;

public class BloodExtractor
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static final String NBT_TAG_CAPACITY = "tankCapacity";
    private static BloodExtractor _instance = null;

    public static BloodExtractor getInstance() {
        return _instance;
    }

    public BloodExtractor(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, BloodExtractorConfig.containerSize, (Fluid)Blood.getInstance());
        this.setPlaceFluids(true);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos blockPos, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(blockPos).func_177230_c();
        if (player.func_70093_af() && Configs.isEnabled(BloodStainedBlockConfig.class) && block == BloodStainedBlock.getInstance()) {
            Random random = world.field_73012_v;
            int amount = 0;
            try {
                amount = ((TileBloodStainedBlock)BloodStainedBlock.getInstance().getTile((IBlockAccess)world, blockPos)).getAmount();
            }
            catch (ConfigurableBlockWithInnerBlocksExtended.InvalidInnerBlocksTileException e) {
                e.printStackTrace();
            }
            int filled = this.fillBloodExtractor(itemStack, amount, !world.field_72995_K);
            BloodStainedBlock.getInstance().unstainBlock(world, blockPos, filled);
            if (filled > 0 && world.field_72995_K) {
                EntityBloodSplashFX.spawnParticles(world, blockPos.func_177982_a(0, 1, 1), 5, 1 + random.nextInt(2));
            }
            return false;
        }
        return super.onItemUseFirst(itemStack, player, world, blockPos, side, hitX, hitY, hitZ);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo((List)list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info.autoSupply"));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(itemStack, world, player);
        }
        MovingObjectPosition target = this.func_77621_a(world, player, false);
        if (!(target != null && target.field_72313_a != MovingObjectPosition.MovingObjectType.MISS || world.field_72995_K)) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return itemStack;
    }

    public int fillBloodExtractor(ItemStack itemStack, int amount, boolean doFill) {
        ItemFluidContainer container = (ItemFluidContainer)itemStack.func_77973_b();
        int filled = container.fill(itemStack, new FluidStack((Fluid)Blood.getInstance(), amount), doFill);
        return filled;
    }

    public void fillForAllBloodExtractors(EntityPlayer player, int minimumMB, int maximumMB) {
        int toFill = minimumMB + field_77697_d.nextInt(Math.max(1, maximumMB - minimumMB));
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext() && toFill > 0) {
            ItemStack itemStack = it.next();
            if (itemStack == null || itemStack.func_77973_b() != BloodExtractor.getInstance()) continue;
            ItemFluidContainer container = (ItemFluidContainer)itemStack.func_77973_b();
            toFill -= container.fill(itemStack, new FluidStack((Fluid)Blood.getInstance(), toFill), true);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill((IFluidContainerItem)this, itemStack, world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public void setCapacity(ItemStack itemStack, int capacity) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        tag.func_74768_a(NBT_TAG_CAPACITY, capacity);
    }

    public int getCapacity(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null || !tag.func_74764_b(NBT_TAG_CAPACITY)) {
            return super.getCapacity(itemStack);
        }
        return tag.func_74762_e(NBT_TAG_CAPACITY);
    }
}

