/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.potion.Potion;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.PrimedPendant;

public class PrimedPendantConfig
extends ItemConfig {
    private static final String DELIMITER = ":";
    public static PrimedPendantConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The capacity of the pendant.", requiresMcRestart=true)
    public static int capacity;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The amount of Blood to drain after one effect application.", isCommandable=true)
    public static int usage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="Usage multipliers. Potion ids are first, followed by floating numbers. A number smaller than one blacklists that potion.", changedCallback=PotionMultipliersChanged.class)
    public static String[] potionMultipliers;
    private Map<Integer, Double> multipliers = Maps.newHashMap();

    public PrimedPendantConfig() {
        super((ModBase)EvilCraft._instance, true, "primedPendant", null, PrimedPendant.class);
    }

    public void registerFromConfig(String[] config) {
        this.multipliers.clear();
        for (String line : config) {
            String[] split = line.split(DELIMITER);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config.");
            }
            try {
                int potionId = Integer.parseInt(split[0]);
                if (potionId >= Potion.field_76425_a.length || Potion.field_76425_a[potionId] == null) {
                    EvilCraft.clog("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config: " + split[0] + " does not refer to an existing potion; skipping.");
                }
                Potion potion = Potion.field_76425_a[potionId];
                double multiplier = 1.0;
                try {
                    multiplier = Double.parseDouble(split[1]);
                }
                catch (NumberFormatException e) {
                    EvilCraft.clog("Invalid ratio '" + split[1] + "' in " + "a Primed Pendant potion multiplier config, using 1.0.", Level.ERROR);
                }
                this.multipliers.put(potion.func_76396_c(), multiplier);
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config: " + split[0] + " is not a number; skipping.");
            }
        }
    }

    public Double getMultiplier(int potionId) {
        return this.multipliers.get(potionId);
    }

    static {
        capacity = 5000;
        usage = 10;
        potionMultipliers = new String[]{Potion.field_76432_h.func_76396_c() + DELIMITER + "-1", Potion.field_76428_l.func_76396_c() + DELIMITER + "10"};
    }

    public static class PotionMultipliersChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        public void onChanged(Object value) {
            if (calledOnce) {
                _instance.registerFromConfig((String[])value);
            }
            calledOnce = true;
        }

        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

