/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.block.ColossalBloodChest;
import org.cyclops.evilcraft.block.ColossalBloodChestConfig;
import org.cyclops.evilcraft.block.ReinforcedUndeadPlank;
import org.cyclops.evilcraft.core.block.AllowedBlock;
import org.cyclops.evilcraft.core.block.CubeDetector;
import org.cyclops.evilcraft.core.block.HollowCubeDetector;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.inventory.container.ContainerColossalBloodChest;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;
import org.cyclops.evilcraft.tileentity.TileWorking;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodchest.BulkRepairItemTickAction;

public class TileColossalBloodChest
extends TileWorking<TileColossalBloodChest, MutableFloat> {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 45;
    public static final int SLOTS = 46;
    public static final int SLOT_CONTAINER = 45;
    public static String TANKNAME = "colossalBloodChestTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    public static final int MAX_EFFICIENCY = 200;
    @NBTPersist
    private Vec3i size = LocationHelpers.copyLocation((Vec3i)Vec3i.field_177959_e);
    @NBTPersist
    private Vec3i renderOffset = new Vec3i(0, 0, 0);
    @NBTPersist
    private Integer efficiency = 0;
    private int repairTicker;
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;
    private final Map<Integer, Boolean> slotTickHistory;
    private Block block = ColossalBloodChest.getInstance();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    private static final Map<Class<?>, ITickAction<TileColossalBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileColossalBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static CubeDetector detector;

    public TileColossalBloodChest() {
        super(46, ColossalBloodChest.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        for (int i = 0; i < 45; ++i) {
            this.addTicker(new TickComponent<TileColossalBloodChest, ITickAction<TileColossalBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<TileColossalBloodChest, ITickAction<TileColossalBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 45, false));
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(45);
        LinkedList<Integer> inSlotsInventory = new LinkedList<Integer>();
        for (int i = 0; i < 45; ++i) {
            inSlotsInventory.add(i);
        }
        this.addSlotsToSide(EnumFacing.EAST, inSlotsTank);
        this.addSlotsToSide(EnumFacing.UP, inSlotsInventory);
        this.addSlotsToSide(EnumFacing.DOWN, inSlotsInventory);
        this.addSlotsToSide(EnumFacing.SOUTH, inSlotsInventory);
        this.addSlotsToSide(EnumFacing.WEST, inSlotsInventory);
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileColossalBloodChest, MutableFloat>(2.0){

            @Override
            public void applyUpgrade(TileColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileColossalBloodChest, MutableFloat>(1.0){

            @Override
            public void applyUpgrade(TileColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.slotTickHistory = Maps.newHashMap();
        this.resetSlotHistory();
    }

    protected void resetSlotHistory() {
        for (int i = 0; i < this.getBasicInventorySize(); ++i) {
            this.slotTickHistory.put(i, false);
        }
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, (CyclopsTileEntity)this, BloodFluidConverter.getInstance());
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 45) {
            return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (SingleUseTank)this.getTank());
        }
        if (slot <= 45 && slot >= 0) {
            return SlotRepairable.checkIsItemValid(itemStack);
        }
        return false;
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        return SlotRepairable.checkIsItemValid(itemStack);
    }

    public Vec3i getSize() {
        return this.size;
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.sendUpdate();
    }

    @Override
    public boolean canWork() {
        Vec3i size = this.getSize();
        return size.func_177953_g(detector.getExactSize()) == 0;
    }

    public static boolean canWork(World world, BlockPos location) {
        TileColossalBloodChest tile = (TileColossalBloodChest)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)location, TileColossalBloodChest.class);
        return tile != null && tile.canWork();
    }

    @Override
    protected int getWorkTicker() {
        return this.repairTicker;
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    @Override
    public void updateTileEntity() {
        this.resetSlotHistory();
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % (long)ColossalBloodChestConfig.ticksPerDamage == 0L) {
            int oldEfficiency = this.efficiency;
            this.efficiency = Math.max(0, this.efficiency - ColossalBloodChestConfig.baseConcurrentItems);
            if (oldEfficiency != this.efficiency) {
                this.sendUpdate();
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (int[])new int[]{this.func_174877_v().hashCode()})) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_174877_v().func_177973_b(new Vec3i((double)range, (double)range, (double)range)), this.func_174877_v().func_177971_a(new Vec3i((double)(1.0f + range), (double)(1.0f + range), (double)(1.0f + range)))));
            for (EntityPlayer player : entities) {
                if (!(player.field_71070_bA instanceof ContainerColossalBloodChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.05f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_72908_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
        this.triggerPlayerUsageChange(1);
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
        this.triggerPlayerUsageChange(-1);
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.block, 1, this.playersUsing);
        }
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return super.func_70300_a(entityPlayer) && (this.field_145850_b == null || this.field_145850_b.func_175625_s(this.func_174877_v()) != this);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177973_b(new Vec3i(3, 3, 3)), this.func_174877_v().func_177982_a(3, 6, 3));
    }

    public void setCenter(BlockPos center) {
        EnumFacing rotation = EnumFacing.NORTH;
        if (center.func_177958_n() != this.func_174877_v().func_177958_n()) {
            rotation = DirectionHelpers.getEnumFacingFromXSign((int)(center.func_177958_n() - this.func_174877_v().func_177958_n()));
        } else if (center.func_177952_p() != this.func_174877_v().func_177952_p()) {
            rotation = DirectionHelpers.getEnumFacingFromZSing((int)(center.func_177952_p() - this.func_174877_v().func_177952_p()));
        }
        this.setRotation(rotation);
        this.renderOffset = this.func_174877_v().func_177973_b((Vec3i)center);
    }

    public Vec3i getRenderOffset() {
        return this.renderOffset;
    }

    public static void detectStructure(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
    }

    public Integer getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(Integer efficiency) {
        this.efficiency = efficiency;
    }

    public Map<Integer, Boolean> getSlotTickHistory() {
        return this.slotTickHistory;
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new BulkRepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
        detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)ReinforcedUndeadPlank.getInstance()), new AllowedBlock((Block)ColossalBloodChest.getInstance()).setExactOccurences(1)}, Lists.newArrayList((Object[])new Block[]{ColossalBloodChest.getInstance(), ReinforcedUndeadPlank.getInstance()})).setExactSize(new Vec3i(2, 2, 2));
    }
}

