/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.block.DarkTank;

public class TileDarkTank
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final int BASE_CAPACITY = 16000;
    public static final String NBT_TAG_TANK = "darkTank";
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);

    public TileDarkTank() {
        super(0, "inventory", 16000, NBT_TAG_TANK);
        this.setSendUpdateOnTankChanged(true);
    }

    public boolean func_94041_b(int index, ItemStack item) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public double getFillRatio() {
        return Math.min(1.0, (double)this.getTank().getFluidAmount() / (double)this.getTank().getCapacity());
    }

    protected boolean shouldAutoDrain() {
        return (Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)DarkTank.DRAINING);
    }

    protected void updateTileEntity() {
        if (!this.func_145831_w().field_72995_K && !this.getTank().isEmpty() && this.shouldAutoDrain()) {
            EnumFacing down = EnumFacing.DOWN;
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(down));
            if (tile instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)tile;
                FluidStack fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount()));
                if (handler.fill(down.func_176734_d(), fluidStack, false) > 0) {
                    int filled = handler.fill(down.func_176734_d(), fluidStack, true);
                    this.drain(filled, true);
                }
            } else {
                List entities = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177972_a(down), this.func_174877_v().func_177972_a(down).func_177982_a(1, 1, 1)), IEntitySelector.field_94557_a);
                for (Entity entity : entities) {
                    if (!this.getTank().isEmpty() && entity instanceof EntityItem) {
                        ItemStack itemStack;
                        ItemStack fillItemStack;
                        EntityItem item = (EntityItem)entity;
                        if (item.func_92059_d() == null || !(item.func_92059_d().func_77973_b() instanceof IFluidContainerItem) || item.func_92059_d().field_77994_a != 1 || (fillItemStack = this.fill(itemStack = item.func_92059_d().func_77946_l())) == null) continue;
                        item.func_92058_a(fillItemStack);
                        continue;
                    }
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
                    while (!this.getTank().isEmpty() && it.hasNext()) {
                        ItemStack fillItemStack;
                        ItemStack itemStack = it.next();
                        if (itemStack == null || !(itemStack.func_77973_b() instanceof IFluidContainerItem) || (fillItemStack = this.fill(itemStack)) == null) continue;
                        it.replace(fillItemStack);
                    }
                }
            }
        }
    }

    protected ItemStack fill(ItemStack itemStack) {
        FluidStack fluidStack;
        ItemStack fillItemStack = itemStack.func_77946_l();
        IFluidContainerItem container = (IFluidContainerItem)itemStack.func_77973_b();
        if (container.fill(fillItemStack, fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(GeneralConfig.mbFlowRate, this.getTank().getFluidAmount())), false) > 0) {
            int filled = container.fill(fillItemStack, fluidStack, true);
            this.drain(filled, true);
            return fillItemStack;
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return from != EnumFacing.DOWN && super.canFill(from, fluid);
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

