/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BoxOfEternalClosure;
import org.cyclops.evilcraft.block.BoxOfEternalClosureConfig;
import org.cyclops.evilcraft.block.DarkBloodBrick;
import org.cyclops.evilcraft.block.SpiritFurnace;
import org.cyclops.evilcraft.core.block.AllowedBlock;
import org.cyclops.evilcraft.core.block.CubeDetector;
import org.cyclops.evilcraft.core.block.HollowCubeDetector;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.world.FakeWorldItemDelegator;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.network.packet.DetectionListenerPacket;
import org.cyclops.evilcraft.tileentity.TileWorking;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.spiritfurnace.BoxCookTickAction;

public class TileSpiritFurnace
extends TileWorking<TileSpiritFurnace, MutableDouble>
implements FakeWorldItemDelegator.IItemDropListener {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int[] SLOTS_DROP = new int[]{2, 3, 4, 5};
    public static final int SLOTS = 2 + SLOTS_DROP.length;
    public static String TANKNAME = "spiritFurnaceTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    public static CubeDetector detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)DarkBloodBrick.getInstance()), new AllowedBlock((Block)SpiritFurnace.getInstance()).setMaxOccurences(1)}, Lists.newArrayList((Object[])new Block[]{SpiritFurnace.getInstance(), DarkBloodBrick.getInstance()})).setMinimumSize(new Vec3i(2, 2, 2));
    private static final Map<Class<?>, ITickAction<TileSpiritFurnace>> BOX_COOK_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileSpiritFurnace>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    @NBTPersist
    private Vec3i size = LocationHelpers.copyLocation((Vec3i)Vec3i.field_177959_e);
    @NBTPersist
    private Boolean forceHalt = false;
    @NBTPersist
    private Boolean caughtError = false;
    private int cookTicker = this.addTicker(new TickComponent<TileSpiritFurnace, ITickAction<TileSpiritFurnace>>(this, BOX_COOK_TICK_ACTIONS, 1));
    private EntityLiving boxEntityCache = null;

    public TileSpiritFurnace() {
        super(SLOTS, SpiritFurnace.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        this.addTicker(new TickComponent<TileSpiritFurnace, ITickAction<TileSpiritFurnace>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(1);
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        for (int slot : SLOTS_DROP) {
            outSlots.add(slot);
        }
        this.addSlotsToSide(EnumFacing.EAST, inSlotsTank);
        this.addSlotsToSide(EnumFacing.UP, inSlots);
        this.addSlotsToSide(EnumFacing.DOWN, outSlots);
        this.addSlotsToSide(EnumFacing.SOUTH, outSlots);
        this.addSlotsToSide(EnumFacing.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileSpiritFurnace, MutableDouble>(1.0){

            @Override
            public void applyUpgrade(TileSpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSpiritFurnace, MutableDouble>(2.0){

            @Override
            public void applyUpgrade(TileSpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, (CyclopsTileEntity)this, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.cookTicker;
    }

    public EntityLiving getEntity() {
        String id;
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem() && (id = BoxOfEternalClosure.getInstance().getSpiritName(boxStack)) != null && !id.equals("vengeanceSpirit")) {
            if (this.boxEntityCache != null && id.equals(EntityList.func_75621_b((Entity)this.boxEntityCache))) {
                return this.boxEntityCache;
            }
            Class entityClass = (Class)EntityList.field_75625_b.get(id);
            if (entityClass != null) {
                EntityLiving entity;
                FakeWorldItemDelegator world = FakeWorldItemDelegator.getInstance();
                this.boxEntityCache = entity = (EntityLiving)EntityList.func_75620_a((String)id, (World)world);
                return entity;
            }
        }
        return null;
    }

    public String getPlayerId() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem()) {
            return BoxOfEternalClosure.getInstance().getPlayerId(boxStack);
        }
        return "";
    }

    public String getPlayerName() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem()) {
            return BoxOfEternalClosure.getInstance().getPlayerName(boxStack);
        }
        return "";
    }

    public boolean isPlayer() {
        return !this.getPlayerId().isEmpty();
    }

    public Vec3i getEntitySize() {
        EntityLiving entity = this.getEntity();
        if (entity == null) {
            return Vec3i.field_177959_e;
        }
        return EntityHelpers.getEntitySize((Entity)entity);
    }

    public boolean isSizeValidForEntity() {
        EntityLiving entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        Vec3i requiredSize = this.getEntitySize();
        return this.getInnerSize().func_177953_g(requiredSize) >= 0;
    }

    @Override
    public boolean canWork() {
        Vec3i size = this.getSize();
        return size.func_177953_g(detector.getMinimumSize()) >= 0;
    }

    public static boolean canWork(World world, BlockPos location) {
        TileEntity tile = world.func_175625_s(location);
        if (tile != null) {
            return ((TileSpiritFurnace)tile).canWork();
        }
        return false;
    }

    public static Item getAllowedCookItem() {
        Item allowedItem = Items.field_151034_e;
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            allowedItem = Item.func_150898_a((Block)BoxOfEternalClosure.getInstance());
        }
        return allowedItem;
    }

    public static void detectStructure(World world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        EvilCraft._instance.getPacketHandler().sendToAllAround((PacketBase)new DetectionListenerPacket(location, valid), LocationHelpers.createTargetPointFromLocation((World)world, (BlockPos)location, (int)50));
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        return itemStack != null && TileSpiritFurnace.getAllowedCookItem() == itemStack.func_77973_b();
    }

    public int getConsumeSlot() {
        return 1;
    }

    public int[] getProduceSlots() {
        return SLOTS_DROP;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return this.canConsume(itemStack);
        }
        if (slot == 0) {
            return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (SingleUseTank)this.getTank());
        }
        return super.func_94041_b(slot, itemStack);
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Vec3i getInnerSize() {
        return LocationHelpers.subtract((Vec3i)this.getSize(), (Vec3i)new Vec3i(1, 1, 1));
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.sendUpdate();
    }

    @Override
    public void onItemDrop(ItemStack itemStack) {
        boolean placed = false;
        int[] slots = this.getProduceSlots();
        for (int i = 0; !placed && i < slots.length; ++i) {
            ItemStack produceStack = this.getInventory().func_70301_a(slots[i]);
            if (produceStack == null) {
                this.getInventory().func_70299_a(slots[i], itemStack);
                placed = true;
                continue;
            }
            if (produceStack.func_77973_b() != itemStack.func_77973_b() || produceStack.func_77976_d() < produceStack.field_77994_a + itemStack.field_77994_a) continue;
            produceStack.field_77994_a += itemStack.field_77994_a;
            placed = true;
        }
        this.forceHalt = !placed;
    }

    @Override
    public void resetWork(boolean hardReset) {
        this.forceHalt = false;
        this.caughtError = false;
        super.resetWork(hardReset);
    }

    public boolean isForceHalt() {
        return this.forceHalt;
    }

    public boolean isCaughtError() {
        return this.caughtError;
    }

    public void caughtError() {
        this.caughtError = true;
    }

    static {
        BOX_COOK_TICK_ACTIONS.put(BoxOfEternalClosure.class, new BoxCookTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }
}

